% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta.coefficient.R
\name{delta.coefficient}
\alias{delta.coefficient}
\title{Delta-beta hat percentage: Change in Coefficients when Adding a Variable}
\usage{
delta.coefficient(model1, model0, variable = NULL)
}
\arguments{
\item{model1}{A fitted model (e.g., \code{glm}, \code{lm}) with the new variable included.}

\item{model0}{A fitted model (e.g., \code{glm}, \code{lm}) without the new variable.}

\item{variable}{A vector of variable names to check. If \code{NULL} (default), checks all coefficients.}
}
\value{
A vector of percentage changes in the coefficients between model1 and model0.
}
\description{
This function checks the percentage change in the coefficient of a variable when
it is added to a model. The comparison is made between two models: model1 (with
the new variable included) and model0 (without the new variable).
}
\details{
This function compares the coefficients of variables between two logistic regression models or conditional logistic regressions:
one that includes a variable of interest (\code{model1}) and one that excludes it (\code{model0}).
It calculates how much the coefficients of other variables change, expressed as a percentage.
The change is calculated as ((beta0 - beta1) / beta1) * 100, where beta0 is the coefficient
from model0 and beta1 is the coefficient from model1.
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 3, Table 3.10

mod3.1 <- glm(fracture ~ priorfrac, family = binomial, data = glow500)
mod3.2 <- glm(fracture ~ priorfrac + height, family = binomial, data = glow500)

# delta-beta-coefficient
delta.coefficient(model1 = mod3.2, model0 = mod3.1, variable = 'priorfrac')

}
