% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_CVrisk.R
\name{compute_CVrisk}
\alias{compute_CVrisk}
\title{Compute multiple CV risk scores}
\usage{
compute_CVrisk(
  df,
  scores = c("ascvd_10y_accaha", "ascvd_10y_frs", "ascvd_10y_frs_simple", "chd_10y_mesa",
    "chd_10y_mesa_cac"),
  age,
  gender,
  race = NULL,
  sbp = NULL,
  bmi = NULL,
  hdl = NULL,
  totchol = NULL,
  bp_med = NULL,
  smoker = NULL,
  diabetes = NULL,
  lipid_med = NULL,
  statin = NULL,
  egfr = NULL,
  fh_heartattack = NULL,
  cac = NULL,
  ...
)
}
\arguments{
\item{df}{input dataframe}

\item{scores}{scores to compute, default is all scores}

\item{age}{patient age in years (required for all scores)}

\item{gender}{patient gender (male or female)}

\item{race}{character string for patient race (white, aa, other) column}

\item{sbp}{character string of systolic blood pressure (in mm Hg) column}

\item{bmi}{character string of Body mass index (kg/m2) column}

\item{hdl}{character string of HDL column}

\item{totchol}{character string of total cholesterol column}

\item{bp_med}{character string of blood pressure medication column}

\item{smoker}{character string of smoking status column}

\item{diabetes}{character string of diabetes status column}

\item{lipid_med}{character string of lipid medication column (used as statin if statin not provided)}

\item{statin}{character string of statin medication column (takes precedence over lipid_med)}

\item{egfr}{character string of estimated glomerular filtration rate column}

\item{fh_heartattack}{character string of fh of heart attack status column}

\item{cac}{character string of cac column}

\item{...}{Additional arguments to pass to score functions (e.g., model parameter for PREVENT scores)}
}
\value{
input data frame with risk score results appended as columns
}
\description{
Compute multiple CV risk scores
}
\examples{

library(CVrisk)
# Compute traditional risk scores
compute_CVrisk(sample_data,
  scores = c("ascvd_10y_accaha", "ascvd_10y_frs", "ascvd_10y_frs_simple",
             "chd_10y_mesa", "chd_10y_mesa_cac", "ascvd_10y_prevent"),
  age = "age", race = "race", gender = "gender", bmi = "BMI", sbp = "sbp",
  hdl = "hdl", totchol = "totchol", bp_med = "bp_med", smoker = "smoker",
  diabetes = "diabetes", lipid_med = "lipid_med", egfr = "egfr",
  fh_heartattack = "fh_heartattack", cac = "cac"
)
}
