% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportVariablesDescription.R
\name{exportVariablesDescription}
\alias{exportVariablesDescription}
\title{Generate descriptions for trial variables}
\usage{
exportVariablesDescription(x, tricot_ranks, measured_traits, block_data)
}
\arguments{
\item{x}{An object of class \code{CM_list} containing raw ClimMob trial data.}

\item{tricot_ranks}{A data frame of tricot rankings generated by \code{exportTricotRanks()}.}

\item{measured_traits}{A data frame of plot data generated by \code{exportMeasuredTraits()}.}

\item{block_data}{A data frame of block-level data generated by \code{exportBlockData()}.}
}
\value{
A data frame describing all trial variables, including name, description,
value type, and optional fields for ontology and controlled vocabularies.
}
\description{
Extracts metadata for variables found in tricot block data and ranking data,
combining question descriptors from the registry and assessments. This function
harmonizes variable names and assigns relevant descriptions, value types, and
placeholders for ontology and controlled vocabularies.
}
\seealso{
Other export functions: 
\code{\link{exportBlockData}()},
\code{\link{exportMeasuredTraits}()},
\code{\link{exportTrialMetadata}()},
\code{\link{exportTricotRanks}()}
}
\concept{export functions}
