% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocabUtilities.R
\name{getConceptClassId}
\alias{getConceptClassId}
\title{Get the concept classes used in a given set of domains}
\usage{
getConceptClassId(cdm, standardConcept = "Standard", domain = NULL)
}
\arguments{
\item{cdm}{A cdm reference via CDMConnector.}

\item{standardConcept}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}

\item{domain}{Character vector with one or more of the OMOP CDM domains.
The results will be restricted to the given domains. Check the available
ones by running getDomains(). If NULL, all supported domains are included:
Condition, Drug, Procedure, Device, Observation, and Measurement.}
}
\value{
The concept classes used for the requested domains.
}
\description{
Get the concept classes used in a given set of domains
}
\examples{
\donttest{
cdm <- mockVocabRef()
getConceptClassId(cdm = cdm, domain = "drug")
}
}
