% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableVocabularies.R
\name{associatedVocabularies}
\alias{associatedVocabularies}
\title{Get the vocabularies associated with a codelist}
\usage{
associatedVocabularies(x, cdm, standardConcept = "Standard", domain = NULL)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{standardConcept}{Character vector with one or more of "Standard",
"Classification", and "Non-standard". These correspond to the flags used
for the standard_concept field in the concept table of the cdm.}

\item{domain}{Character vector with one or more of the OMOP CDM domains.
The results will be restricted to the given domains. Check the available
ones by running availableDomains(). If NULL, all supported domains are included:
Condition, Drug, Procedure, Device, Observation, and Measurement.}
}
\value{
Names of available vocabularies.
}
\description{
Get the vocabularies associated with a codelist
}
\examples{
\donttest{
library(CodelistGenerator)
library(omock)

# Create CDM object
cdm <- mockCdmReference()

# Get all vocabularies from a codelist
codelist <- newCodelist(list("codes1" = c(35604877L, 35604394L),
                             "codes2" = c(4214687L)))
associatedVocabularies(cdm = cdm,
                      x = codelist)
}
}
