% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratifyByBrand.R
\name{stratifyByBrand}
\alias{stratifyByBrand}
\title{Stratify a codelist by brand category.}
\usage{
stratifyByBrand(
  x,
  cdm,
  nameStyle = "{codelist_name}_{brand}",
  keepOriginal = FALSE
)
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference to an OMOP CDM dataset. If data is held within a
database, the vocabulary tables should be in the same schema as the clinical
tables (person, observation period, and so on).}

\item{nameStyle}{Naming of the new codelists, use \code{{codelist_name}} to
include the codelist name and \code{{brand}} to include the brand name.}

\item{keepOriginal}{Whether to keep the original codelist (TRUE) or just return
the stratified ones (FALSE).}
}
\value{
The codelist with the required stratifications, as different elements
of the list.
}
\description{
Stratify a codelist by brand category.
}
\examples{
\donttest{
library(CodelistGenerator)

cdm <- mockVocabRef()
codes <- newCodelist(list(
  concepts_1 = c(20L, 21L, 22L),
  concepts_2 = c(10L, 13L, 21L)
))

new_codes <- stratifyByBrand(x = codes,
                             cdm = cdm,
                             keepOriginal = TRUE)
new_codes
}
}
