% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.R
\name{test_covariance_structure}
\alias{test_covariance_structure}
\title{Test for structure of data's covariance matrix}
\usage{
test_covariance_structure(X, structure, method = "BT", repetitions = 1000)
}
\arguments{
\item{X}{a matrix containing the observation vectors as columns
(one group only)}

\item{structure}{a character specifying the structure regarding the
covariance matrix should be checked. Options are "autoregressive" ("ar"),
"FO-autoregressive" ("FO-ar"), "diagonal" ("diag"), "sphericity" ("spher"),
"compoundsymmetry" ("cs") and "toeplitz" ("toep").}

\item{method}{a character, to chose whether bootstrap("BT") or
Monte-Carlo-technique("MC") is used, while bootstrap is the
predefined method.}

\item{repetitions}{a scalar, indicate the number of runs for the chosen
method.
The predefined value is 1,000, and the number should not be below 500.}
}
\value{
an object of the class \code{\link{CovTest}}
}
\description{
This function conducts the test for the covariance matrix of
data regarding structures. Depending on the chosen method a bootstrap or
Monte-Carlo-technique is used to calculate p-value of the
Anova-type-statistic(ATS) based on a specified number of runs.
}
\examples{
# Load the data
data("EEGwide", package = "MANOVA.RM")

# Select only the males with the diagnosis AD
X <- as.matrix(EEGwide[EEGwide$sex == "W" & EEGwide$diagnosis == "AD",
                          c("brainrate_temporal", "brainrate_frontal",
                          "brainrate_central","complexity_temporal",
                          "complexity_frontal", "complexity_central")])

test_covariance_structure(X = X, structure = "diagonal", method = "MC")

}
\references{
Sattler, P. and Dobler, D. (2025). Testing for patterns and structures in covariance and correlation matrices. \emph{arXiv preprint} \url{https://arxiv.org/abs/2310.11799}
}
