% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residSVD2.R
\name{residSVD2}
\alias{residSVD2}
\title{Function to extract the resid from SVD}
\usage{
residSVD2(model, fac1, fac2, d = 1)
}
\arguments{
\item{model}{object with \link[stats]{na.action}, \link[stats]{residuals}, and \link[stats]{weights} methods, e.g. objects inheriting from class \code{"gnm"}.}

\item{fac1}{first factor.}

\item{fac2}{second factor.}

\item{d}{integer, the number of multiplicative terms to use in the approximation.}
}
\value{
If \code{d = 1}, a numeric vector; otherwise a numeric matrix with \code{d} columns.
}
\description{
This function uses the first \code{d} components of the singular value
decomposition in order to approximate a vector of model residuals by a
sum of \code{d} multiplicative terms, with the multiplicative
structure determined by two specified factors follows the SVD function by Turner et al. (2023).
For \code{glm} and \code{gnm} models from the \code{gnm} R-packages,
the matrix entries are weighted working residuals.  The primary use of \code{residSVD} is to
generate good starting values for the parameters in \link[gnm]{Mult} terms
in models to be fitted using \link[gnm]{gnm}. In this case, we modified the function
in order to obtain good starting values for the multi-population mortality models.
}
\references{
Turner, H., & Firth, D. (2023).
Generalized nonlinear models in R: An overview of the gnm package.
R package version 1.1-5. https://CRAN.R-project.org/package=gnm
}
\seealso{
\code{\link{fitLCmulti}}, \code{\link{forecast.fitLCmulti}}
\code{\link{multipopulation_cv}}, \code{\link{plot.fitLCmulti}}
\code{\link{plot.forLCmulti}}
}
