\name{Many PaF income polarization indices}
\alias{colpafs}
\title{
Many PaF income polarization indices
}

\description{
Many PaF income polarization indices
}

\usage{
colpafs(y, a, ncores = 1)
}

\arguments{
\item{y}{
A numeric matrix with income data. The PaF index will be computed for each
column seperately.
}
\item{a}{
The value of \eqn{\alpha}, a number between 0.25 and 1.
}
\item{ncores}{
The number of cores to use. If greater than 1, parallel computing will take
place. It is advisable to use it if you have many observations and or many
variables, otherwise it will slow down the process. The default is 1, meaning
that code is executed serially.
}
}

\details{
The function compute the PaF index of Duclos, Esteban and Ray (2004) for a
specific value of \eqn{\alpha}, for each column of the matrix.
}

\value{
A matrix, where each row contains the PaF index, the alienation (twice the Gini
index) and identification components and 1 + the normalized covariance.
}

\references{
Duclos J. Y., Esteban, J. and Ray D. (2006). Polarization: concepts,
measurement, estimation. In The Social Economics of Poverty (pp. 54--102).
Routledge.

Duclos J. Y., Esteban, J. and Ray D. (2004). Polarization: concepts,
measurement, estimation. Econometrica, 72(6): 1737--1772.
}

\author{
Michail Tsagris and Christos Adam.

R implementation and documentation: Michail Tsagris \email{mtsagris@uoc.gr}
and Christos Adam \email{econp266@econ.soc.uoc.gr}.
}

%\note{
%%  ~~further notes~~
%}

\seealso{
\code{\link{paf}, \link{colpafs2}
}
}

\examples{
y <- matrix( rgamma(100 * 10, 10, 0.01), ncol = 10 )
colpafs(y, 0.25)
}
