% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symptoms.R
\docType{data}
\name{symptoms}
\alias{symptoms}
\title{DIVINE's symptoms table}
\format{
A data frame with 5813 rows and 24 columns
\describe{
\item{record_id:}{Identifier of each record. This information does not match the real data.}
\item{covid_wave:}{A factor with levels \verb{Wave 1}, \verb{Wave 2}, \verb{Wave 3}, and \verb{Wave 5}. COVID-19 wave.}
\item{center:}{A factor with levels \verb{Hospital A}, \verb{Hospital B}, \verb{Hospital C}, \verb{Hospital D}, and             \verb{Hospital E}. Center of admission}
\item{symptoms_days:}{Days from symptoms onset to hospitalization}
\item{rhinorrhea:}{A factor with levels \code{No} and \code{Yes}. Rhinorrhea}
\item{anosmia:}{A factor with levels \code{No} and \code{Yes}. Anosmia}
\item{ageusia:}{A factor with levels \code{No} and \code{Yes}. Ageusia}
\item{arthromyalgia:}{A factor with levels \code{No} and \code{Yes}. Arthromyalgia}
\item{odynophagia:}{A factor with levels \code{No} and \code{Yes}. Odynophagia}
\item{fever:}{A factor with levels \code{No} and \code{Yes}. Fever}
\item{cough:}{A factor with levels \code{No} and \code{Yes}. Cough}
\item{dyspnea:}{A factor with levels \code{No} and \code{Yes}. Dyspnoea}
\item{expectoration:}{A factor with levels \code{No} and \code{Yes}. Expectoration}
\item{diarrhea:}{A factor with levels \code{No} and \code{Yes}. Diarrhea}
\item{vomit:}{A factor with levels \code{No} and \code{Yes}. Vomiting}
\item{nausea:}{A factor with levels \code{No} and \code{Yes}. Nausea}
\item{asthenia:}{A factor with levels \code{No} and \code{Yes}. Asthenia}
\item{anorexia:}{A factor with levels \code{No} and \code{Yes}. Anorexia}
\item{cephal:}{A factor with levels \code{No} and \code{Yes}. Headache}
\item{chest_pain:}{A factor with levels \code{No} and \code{Yes}. Chest pain}
\item{abdominal_pain:}{A factor with levels \code{No} and \code{Yes}. Abdominal pain}
\item{confusional_syndrome:}{A factor with levels \code{No} and \code{Yes}. Confusional syndrome}
\item{shock_admission:}{A factor with levels \code{No} and \code{Yes}. Shock on admission}
\item{bacterial_infection:}{A factor with levels \code{No} and \code{Yes}. Bacterial infection}
}
}
\usage{
data(symptoms)
}
\description{
Information on COVID-19 associated symptoms of patients included in the DIVINE cohort. Data was collected at hospital admission.
}
\references{
Pallarès, N., Tebé, C., Abelenda-Alonso, G., Rombauts, A., Oriol, I., Simonetti, A. F., Rodríguez-Molinero, A., Izquierdo, E., Díaz-Brito, V., Molist, G., Gómez Melis, G., Carratalà, J., Videla, S., & MetroSud and Divine study groups (2023). Characteristics and Outcomes by Ceiling of Care of Subjects Hospitalized with COVID-19 During Four Waves of the Pandemic in a Metropolitan Area: A Multicenter Cohort Study. Infectious diseases and therapy, 12(1), 273–289. https://doi.org/10.1007/s40121-022-00705-w
}
\keyword{datasets}
