% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPC.R
\name{DPC}
\alias{DPC}
\title{Distributed Principal Component Analysis}
\usage{
DPC(data, m, n1, K)
}
\arguments{
\item{data}{A numeric matrix containing the total dataset.}

\item{m}{An integer specifying the number of principal components.}

\item{n1}{An integer specifying the length of each data subset.}

\item{K}{An integer specifying the number of nodes.}
}
\value{
A list with the following components:
\describe{
  \item{Ahat}{List of estimated loading matrices for each node.}
  \item{Dhat}{List of diagonal residual variance matrices for each node.}
  \item{Sigmahat}{List of covariance matrices for each node.}
}
}
\description{
Performs distributed principal component analysis on a numeric dataset
split across multiple nodes. Estimates loading matrices, residual variances, and
covariance matrices for each node.
}
\examples{
set.seed(123)
data <- matrix(rnorm(500), nrow = 100, ncol = 5)
DPC(data = data, m = 3, n1 = 20, K = 5)

}
