% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentations.R
\docType{data}
\name{interaction_score_graphs_example}
\alias{interaction_score_graphs_example}
\title{Interaction score graphs}
\format{
A named list with 2 items.
\describe{
  \item{groupA}{iGraph graph object containing the interaction score as weight for groupA.}
  \item{groupB}{}
}
}
\source{
Krug, Karsten et al. “Proteogenomic Landscape of Breast Cancer Tumorigenesis and Targeted
 Therapy.” Cell vol. 183,5 (2020): 1436-1456.e31. doi:10.1016/j.cell.2020.10.036

The Drug Gene Interaction Database: \url{https://dgidb.org/}
}
\usage{
interaction_score_graphs_example
}
\description{
Exemplary intermediate pipeline output: Interaction score graphs example data built by
\code{\link[DrDimont]{generate_interaction_score_graphs}} using \link[DrDimont]{combined_graphs_example}
and \link[DrDimont]{drug_target_edges_example}.
A named list (elements `groupA` and `groupB`). Each element contains an iGraph
object containing edge attributes: the correlation values as `weight` and the
interaction score as `interactionweight`.
}
\details{
A subset of the original data by Krug et al. (2020) and randomly sampled metabolite
data from \code{\link[DrDimont]{layers_example}} was used to generate the correlation
matrices, individual graphs, and combined graphs. They were created from data
stratified by estrogen receptor (ER) status: `groupA` contains data of ER+
patients and `groupB` of ER- patients. Drug-gene interactions were used from
The Drug Gene Interaction Database.
}
\keyword{datasets}
