% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan.R
\name{epinow2_stan_model}
\alias{epinow2_stan_model}
\title{Return a stan model object for the appropriate backend}
\usage{
epinow2_stan_model(
  backend = c("rstan", "cmdstanr"),
  model = c("estimate_infections", "simulate_infections", "estimate_secondary",
    "simulate_secondary", "estimate_truncation", "dist_fit")
)
}
\arguments{
\item{backend}{Character string indicating the backend to use for fitting
stan models. Supported arguments are "rstan" (default) or "cmdstanr".}

\item{model}{A character string indicating the model to use. One of
"estimate_infections" (default), "simulate_infections",
"estimate_secondary", "simulate_secondary", "estimate_truncation" or
"dist_fit".}
}
\value{
A stan model object (either \code{rstan::stanmodel} or
\code{cmdstanr::CmdStanModel}, depending on the backend)
}
\description{
Return a stan model object for the appropriate backend
}
\keyword{internal}
