% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{AccountingExample}
\alias{AccountingExample}
\title{Synthetic accounting dataset example, from Excel}
\format{
\subsection{\code{AccountingExample}}{

data frame with 8 rows and 6 columns:
\describe{
\item{Year}{Four-digit integer year, with missing values coded NA}
\item{Quarter}{Two-character quarter designation, Q1 through Q4}
\item{CurrentTotal}{Dollar amount with dollar signs, commas, and decimal points}
\item{PriorYearTotal}{Dollar amount with dollar signs, commas, and decimal points}
\item{YOYchange}{Dollar amount with dollar signs, commas, decimal points and parentheses to indicate negative values}
\item{PctChange}{Ratio of YOYchange to CurrentTotal, converted to a percentage, with percent sign}
}
}
}
\usage{
AccountingExample
}
\description{
Small dataset illustrating various unexpected data formats arising
from the accounting data format in an Excel spreadsheet.  Variables
that appear to be numeric based on the name are represented as
character strings with embedded commas, dollar signs, percent signs,
and parentheses to indicate negative numbers
}
\keyword{datasets}
