% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompareNumericSets.R
\name{CompareNumericSets}
\alias{CompareNumericSets}
\title{Compare distributions of numerical variables between subsets}
\usage{
CompareNumericSets(DF, IndexA, numVars, IndexB = NULL, cLevel = 0.95)
}
\arguments{
\item{DF}{data frame containing all variables in \code{numVars}}

\item{IndexA}{record index defining the first record subset to be compared}

\item{numVars}{vector of numerical variable names from \code{DF}}

\item{IndexB}{record index defining the second record subset to be compared
(default NULL means the second set contains all records not included in the first)}

\item{cLevel}{confidence level for the Welch rank test (default = 0.95)}
}
\value{
data frame with one row for each element of \code{numVars} and columns
containing the \code{numVars} element name and all columns from WelchRankTest
for that variable
}
\description{
Sets up and calls WelchRankTest to compare the distributions of
a set of numerical variables between two record subsets.  If the
set of numerical variables contains a single element, this function
effectively reduces to WelchRankTest.
}
\examples{
x <- seq(-1, 1, length = 200)
a <- rep(c("a", "b"), 100)
offset <- rep(c(0, 0.2), 100)
xMod <- x + offset
DF <- data.frame(numVar = x, numVar2 = xMod, setVar = a)
indexA <- which(DF$setVar == "a")
CompareNumericSets(DF, indexA, c("numVar", "numVar2"))
}
