% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeOutlierLimits.R
\name{ComputeOutlierLimits}
\alias{ComputeOutlierLimits}
\title{Compuute outlier limits by three methods}
\usage{
ComputeOutlierLimits(x, method, t = NULL)
}
\arguments{
\item{x}{numerical vector in which outliers are to be detected}

\item{method}{single character specifying the outlier rule (T, H, or B)}

\item{t}{threshold parameter (default NULL, gives 3 for T and H rules, 1.5 for B rule)}
}
\value{
named numerical vector with these 4 elements:
\itemize{
\item nRec the number of elements in \code{x}
\item nonMiss the number of non-missing elements in \code{x}
\item loLim the lower outlier threshold for \code{x} elements
\item upLim the upper outlier threshold for \code{x} elements
}
}
\description{
Compute upper and lower outlier limits by three detection rules:
the 3-sigma edit rule, the Hampel identifier, or the boxplot rule
}
\examples{
x <- seq(-1, 1, length = 100)
x[1:10] <- 10
ComputeOutlierLimits(x, "T")
ComputeOutlierLimits(x, "H")
ComputeOutlierLimits(x, "B")
}
