% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.CatDiffs.R
\name{plot.CatDiffs}
\alias{plot.CatDiffs}
\title{Plot significant categorical level differences between data subsets}
\usage{
\method{plot}{CatDiffs}(x, ..., labelA, labelB, nMax = 20, levelFrac = 0.5, xLims = NULL)
}
\arguments{
\item{x}{an S3 object of class CatDiffs}

\item{...}{optional named parameters to be passed to \code{\link[=plot]{plot()}}}

\item{labelA}{plot label identifying the first data subset}

\item{labelB}{plot label identifying the second data subset}

\item{nMax}{maximum number of levels to include in the barplot
(default = 20)}

\item{levelFrac}{relative position of the level labels on the barplot
(default = 0.5)}

\item{xLims}{two-element vector of x-axis limits for the barplot
(default sets the range from 0 to 1.2 times the length of the longest
bar on the plot)}
}
\value{
None: this method generates a plot from \code{x}
}
\description{
Plot method for S3 objects of class CatDiffs generated by the
\code{\link[=CompareCategoricalLevels]{CompareCategoricalLevels()}} function, creating a horizontal barplot
of categorical variable level frequencies that differ significantly
between two data subsets
}
\examples{
catVar <- c(rep("a", 100), rep("b", 100), rep("c", 100))
auxVar <- c(rep("Set1", 30), rep("Set2", 70),
           rep("Set1", 50), rep("Set2", 50),
           rep("Set1", 90), rep("Set2", 10))
DF <- data.frame(catVar = catVar, auxVar = auxVar)
indexA <- which(DF$auxVar == "Set1")
CatDiffObj <- CompareCategoricalLevels(DF, "catVar", indexA)
plot(CatDiffObj, labelA = "Set1", labelB = "Set2")
}
