% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_co2.R
\name{flex_co2}
\alias{flex_co2}
\title{Obtain cutoffs for fit indices simulated by gen_fit2.}
\usage{
flex_co2(
  fits = NULL,
  correct.fits = NULL,
  miss.fits = NULL,
  index = "CFI",
  alpha = c(0.05),
  beta = c(0.05, 0.1)
)
}
\arguments{
\item{fits}{The object returned from gen_fit2 which is a list of correct fit values and misspecified fit values.}

\item{correct.fits}{For compatibility reasons, the correct fit values can be defined separately.}

\item{miss.fits}{For compatibility reasons, the misspecified fit values can be defined separately.}

\item{index}{A vector of length >= 1 with names of fit indices the user wishes to explore. Capitalization does not matter, either e.g., CFI or cfi are accepted. Default is CFI as it might be easier to understand.}

\item{alpha}{The acceptable Type I error representing the empirical quantile p, see details in gen_fit2. Multiple values can be provided as a vector.  Default is .05.}

\item{beta}{The acceptable Type II error representing the empirical quantile p, see details in gen_fit2. Multiple values can be provided as a vector. Default is c(.05, .10).}
}
\value{
A list consisting of a tibble for the empirical quantiles estimated for the provided alpha, beta values and indices, a tibble for the derived cutoff values for each parameter (alpha, beta, approach, index, cutoff), a tibble for the evaluation (also True Negatives, False Positives, True Positives, False Negatives, Type I error, Type II error, Sum of both Types, Power and Specificity), a vector for the notation on the evaluation tibble, and a tibble displaying overlap statistics for each index (Overlap percentage, AUC, U-test).
}
\description{
Obtain cutoffs for fit indices simulated by gen_fit2.
}
\details{
This function returns cutoffs for the the fit indices simulated by gen_fit2. For details, please refer to gen_fit2. Please note that the results are only based on the simulation of the model specified and its misspecified variant under the conditions of the gen_fit2 function.
}
\examples{
\donttest{#Simple example
library(lavaan)
library(dplyr)
HS.model <- ' visual  =~ x1 + x2 + x3
              textual =~ x4 + x5 + x6
             speed   =~ x7 + x8 + x9 '

fit <- cfa(
  HS.model,
  data = HolzingerSwineford1939
)
#Note: Demonstration only! Please use higher numbers of replications for your applications (>= 500).
fits <- gen_fit2(fit = fit, rep = 100)
#Default evaluation:
flex_co2(fits)
#Changed alpha and beta values:
flex_co2(fits, alpha = .05, beta = .05)
flex_co2(fits, alpha = .10, beta = .20)
#Different fit indices:
flex_co2(fits, index = c("CFI", "SRMR", "RMSEA"))
}
}
