## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  echo = TRUE,
  warning = FALSE,
  eval = FALSE  # Set to TRUE when running
)

## -----------------------------------------------------------------------------
# library(FIND)

## -----------------------------------------------------------------------------
# # Create a 3plus3 design
# design_3 <- design_3plus3(
#   npts = 12,
#   ncohort = 10,
#   cohortsize = 3
# )
# 
# # Create an i3plus3 design
# design_i3 <- design_i3plus3(
#   pT = 0.25,
#   EI = c(0.2, 0.3),
#   npts = 12,
#   ncohort = 10,
#   cohortsize = 3
# )
# 
# # Print the design
# print(design_3)
# print(design_i3)

## -----------------------------------------------------------------------------
# # Generate decision table for 3plus3
# decision_3 <- get_decision(design_3)
# 
# # Generate decision table for i3plus3
# decision_i3 <- get_decision(design_i3)
# 
# # View the decision table
# head(decision_3$tab)
# head(decision_i3$tab)

## -----------------------------------------------------------------------------
# # Compare decision tables for 3plus3 and i3plus3
# decision_table(design_3, design_i3)

## -----------------------------------------------------------------------------
# # Create output folder with timestamp
# output_folder <- paste0("FIND_output_", format(Sys.time(), "%Y%m%d_%H%M%S"))
# dir.create(output_folder, showWarnings = FALSE)
# 
# # Generate and save decision table plot
# p <- decision_table(design_3, design_i3)
# ggsave(
#   filename = file.path(output_folder, "decision_table_comparison.png"),
#   plot = p,
#   width = 10,
#   height = 6,
#   dpi = 300
# )

## -----------------------------------------------------------------------------
# # g3 design
# design_g3 <- design_g3plus3(
#   npts = 12,
#   ncohort = 10,
#   cohortsize = 3
# )
# 
# # mtpi2 design
# design_mtpi <- design_mtpi2(
#   pT = 0.25,
#   EI = c(0.2, 0.3),
#   npts = 12,
#   ncohort = 10
# )
# 
# # boin design
# design_b <- design_boin(
#   pT = 0.25,
#   EI = c(0.15, 0.35),
#   npts = 12,
#   ncohort = 10,
#   cohortsize = 3
# )
# 
# # Compare all designs
# decision_table(design_3, design_i3, design_g3, design_mtpi, design_b)

## -----------------------------------------------------------------------------
# # Define toxicity scenario
# p.true <- c(0.05, 0.10, 0.20, 0.30, 0.45)
# mtd.true <- c(0, 0, 1, 0, 0)  # Dose 3 is MTD

## -----------------------------------------------------------------------------
# # Run simulation for 3plus3
# sim_3 <- run_simulation(design_3, p.true = p.true, mtd.true = mtd.true)
# 
# # Run simulation for i3plus3
# sim_i3 <- run_simulation(design_i3, p.true = p.true, mtd.true = mtd.true)
# 
# # View results
# sim_3$selection
# sim_3$allocation
# 
# sim_i3$selection
# sim_i3$allocation

## -----------------------------------------------------------------------------
# # Define multiple scenarios
# p.true <- matrix(
#   c(0.05, 0.10, 0.20, 0.30, 0.45,
#     0.10, 0.15, 0.25, 0.35, 0.50),
#   nrow = 2, byrow = TRUE
# )
# 
# mtd.true <- matrix(
#   c(0, 0, 1, 0, 0,
#     0, 0, 1, 0, 0),
#   nrow = 2, byrow = TRUE
# )
# 
# # Run simulations
# sim_3 <- run_simulation(design_3, p.true = p.true, mtd.true = mtd.true)
# sim_i3 <- run_simulation(design_i3, p.true = p.true, mtd.true = mtd.true)

## -----------------------------------------------------------------------------
# # Load pre-defined scenarios
# scenarios <- load_true(pT = 0.25)
# 
# # Use a specific scenario
# p.true <- scenarios[["FFP-BOIN provided"]][["p.true"]][5,]
# mtd.true <- c(0, 0, 0, 0, 1, 0)  # Dose 5 is MTD
# 
# # Run simulations
# sim_3 <- run_simulation(design_3, p.true = p.true, mtd.true = mtd.true)
# sim_i3 <- run_simulation(design_i3, p.true = p.true, mtd.true = mtd.true)

## -----------------------------------------------------------------------------
# # Compare OC plots for 3plus3 and i3plus3
# oc_plot(sim_3, sim_i3)

## -----------------------------------------------------------------------------
# # Create output folder with timestamp (if not already created)
# output_folder <- paste0("FIND_output_", format(Sys.time(), "%Y%m%d_%H%M%S"))
# dir.create(output_folder, showWarnings = FALSE)
# 
# # Generate and save OC plot
# p <- oc_plot(sim_3, sim_i3)
# ggsave(
#   filename = file.path(output_folder, "oc_plot_comparison.png"),
#   plot = p,
#   width = 12,
#   height = 8,
#   dpi = 300
# )

## -----------------------------------------------------------------------------
# # Create design with specific simulation settings
# design_i3_custom <- design_i3plus3(
#   pT = 0.25,
#   EI = c(0.2, 0.3),
#   npts = 12,
#   ncohort = 15,          # More cohorts
#   cohortsize = 3,
#   ntrial = 1000,         # Number of simulation trials
#   n.earlystop = 18,      # Early stopping parameter
#   extrasafe = TRUE       # Extra safety rule
# )
# 
# # Run simulation with custom settings
# sim_i3_custom <- run_simulation(design_i3_custom, p.true = p.true, mtd.true = mtd.true)

