% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_decision_g3plus3.R
\name{get_decision_g3plus3}
\alias{get_decision_g3plus3}
\title{Dosing decision for the G3 design}
\usage{
get_decision_g3plus3(npts = 12)
}
\arguments{
\item{npts}{the number of participants within which dosing decisions are generated.}
}
\value{
\code{get_decision_g3plus3()} returns:

(1) a dataframe containing the decisions (E, S, D or DU) for each combination of y and n (\code{$tab}),

(2) a list (\code{$setup}) containing user input parameters, such as npts.
}
\description{
Generate dosing decisions (E, S, D or DU) of the G3 design for user-specified number of participants.
}
\details{
Denote the current dose \eqn{d}. Let \eqn{n_d} and \eqn{y_d} represent the
          number of participants treated at dose \eqn{d} and the number of participants
          experienced DLT, respectively. Let \eqn{p_d} be the toxicity probability at
          dose \eqn{d}. Also, denote \eqn{\frac{y_d}{n_d}} the observed toxicity rate
          at the current dose.

          The G3 design uses the following decision rules. For \eqn{n} is three or six,
          we simply apply the 3+3 rules; otherwise, we use the following decision rules,
          with EI being [0.2, 0.29]. If \eqn{\frac{y_d}{n_d}} is lower than the escalation
          boundary (i.e. below the EI), the decision is to escalate to the next higher dose;
          if \eqn{\frac{y_d}{n_d}} is between the escalation and de-escalation boundaries
          (between the EI), the decision is to stay at the current dose; if
          \eqn{\frac{y_d}{n_d}} is higher than the de-escalation boundary (i.e. above
          the EI), the decision is to de-escalate to the next lower dose.

          Also, the G3 design includes a dose exclusion rule. If \eqn{Pr(p_d > 0.25 | y_d , n_d ) > 0.95},
          dose \eqn{d} and those higher than \eqn{d} are removed from the trial since they
          are deemed excessively toxic.
}
\examples{

get_decision_g3plus3(npts = 12)

}
\references{
To be added.
}
