% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_metric.R
\name{summarize_metric}
\alias{summarize_metric}
\title{Summarize after conducting simulations}
\usage{
summarize_metric(select.perc,
                        stop.perc,
                        nptsdose,
                        npts,
                        mtd.true)
}
\arguments{
\item{select.perc}{the selection percentage for each dose.}

\item{stop.perc}{the percentage of early stopping without selecting the MTD.}

\item{nptsdose}{the number of participants treated for each dose.}

\item{npts}{the average number of participants treated.}

\item{mtd.true}{a vector (or a matrix) with the same dimension as
the vector (or matrix) containing the true toxicity probabilities (\code{$p.true}).
It should takes value of 0 or 1, and 1 specifies the true MTD.}
}
\value{
\code{summarize_metric()} returns:

(1) a dataframe (\code{$selection}) with each column showing:
       the numbered index for each scenarios specified,
       the selection percentage at each dose level,
       the percentage of early stopping without selecting the MTD,
       the percentage of overdosing selection (POS),
       the percentage of correct selection (PCS),
       the percentage of underdosing selection (PUS), respectively.

(2) a dataframe (\code{$allocation}) with each column showing:
       the numbered index for each scenarios specified,
       the number of participants treated at each dose level,
       the average number of participants treated,
       the percentage of overdosing allocation (POA),
       the percentage of correct allocation (PCA),
       the percentage of underdosing allocation (PUA), respectively.
}
\description{
Summarize after conducting simulations
}
\examples{
summarize_metric(select.perc = c(0.588, 0.218, 0.025, 0.0, 0.0, 0.0),
                           stop.perc = 0.168,
                           nptsdose = c(20.53, 9.03, 2.48, 0.29, 0.01, 0.00),
                           npts = 32.4,
                           mtd.true = c(1,0,0,0,0,0))
}
