% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_test.R
\name{post_hoc_chi2}
\alias{post_hoc_chi2}
\title{Performs post hoc analysis for chi-squared or Fisher's exact test}
\usage{
post_hoc_chi2(
  x,
  method = "fisher",
  method_adjust = "BH",
  digits = 3,
  count = FALSE,
  ...
)
}
\arguments{
\item{x}{Data frame, vector, or table. If numeric, treated as a contingency
table and the names are considered as categories; otherwise, the levels of
the factor or the characters are used.}

\item{method}{Character specifying the statistical test: \code{chisq} for chi-squared
or \code{fisher} for Fisher's exact test.}

\item{method_adjust}{Character specifying the p-value adjustment method.}

\item{digits}{Integer specifying the number of decimal places for the test
statistic.}

\item{count}{Logical specifying if \code{x} is a contingency table.}

\item{...}{Additional arguments passed to \code{chisq.test} or \code{fisher.test}.}
}
\value{
A tibble with pairwise test results containing the following columns:
\describe{
\item{group1, group2}{Character vectors specifying the pair of groups being compared.}
\item{n}{Numeric vector specifying the total count or sample size for the comparison.}
\item{statistic}{Numeric vector specifying the test statistic (for chi-squared tests only).}
\item{df}{Numeric vector specifying the degrees of freedom (for chi-squared tests only).}
\item{p}{Raw p-value for the pairwise comparison, formatted as numeric or character
("< 0.001" for very small p-values).}
\item{p.signif}{Character vectors specifying the significance codes for raw p-values: 'ns' (not significant).}
\item{FDR}{False Discovery Rate adjusted p-value using the specified method,
formatted as numeric or character ("< 0.001" for very small values).}
\item{fdr.signif}{Character vectors specifying the significance codes for FDR-adjusted p-values: 'ns' (not significant),
'\emph{' (p < 0.05), '\strong{' (p < 0.01), '}}' (p < 0.001).}
}
For Fisher's exact tests, the \code{statistic} and \code{df} columns are not included..
}
\description{
Identifies pairwise differences between categories following a chi-squared
or Fisher's exact test.
}
\details{
If x is numeric, it is treated as a contingency table and the names
are considered as categories; otherwise, the levels of the factor or the
characters are used.
}
\examples{
x <- c(rep("A", 100), rep("B", 78), rep("C", 25))
post_hoc_chi2(x)

x <- data.frame(G1 = c(Yes = 100, No = 78), G2 = c(Yes = 75, No = 23))
post_hoc_chi2(x, count = TRUE, method = "chisq")

data("housetasks")
housetasks[, c("Wife", "Husband")] \%>\%
    t() \%>\%
    post_hoc_chi2(count = TRUE, workspace = 1e6)

x <- cbind(
    mapply(function(x, y) rep(x, y), letters[seq(3)], c(7, 5, 8)) \%>\% unlist(),
    mapply(function(x, y) rep(x, y), LETTERS[seq(3)], c(6, 6, 8)) \%>\% unlist()
)
post_hoc_chi2(x)

}
