\name{gsom_Umatrix}
\alias{gsom_Umatrix}
\title{Compute the U-Matrix for a trained Gower-SOM}
\description{
Calculates the U-Matrix (unified distance matrix) to visualize the topology
and cluster structure of a Self-Organizing Map trained on mixed-attribute data.
Each entry contains the average Gower distance between a neuron and its
immediate neighbors in the rectangular grid.
}
\details{
The function assumes a rectangular topology where each neuron has up to
four direct neighbors (up, down, left, right). For each neuron, the mean
Gower distance to its valid neighbors is computed using
\code{\link[cluster]{daisy}} with \code{metric = "gower"}.
}
\usage{
gsom_Umatrix(codebook, n_rows, n_cols)
}
\arguments{
  \item{codebook}{A data.frame or matrix containing the SOM prototypes
    (weights), with one row per neuron.}
  \item{n_rows}{Integer, number of rows in the SOM grid.}
  \item{n_cols}{Integer, number of columns in the SOM grid.}
}
\value{
A numeric matrix of size \code{n_rows x n_cols}, where each cell contains
the average distance between the corresponding neuron and its neighbors.
}

\author{
  Patricio Sáez <patricsaez@udec.cl>;
  Patricio Salas <patricioasalas@udec.cl>
}

\references{
Sáez, P., Salas, P. Gower-SOM: a self-organizing map for mixed data with gower distance and heuristic adaptation for data analytics. Int J Data Sci Anal 22, 26 (2026). https://doi.org/10.1007/s41060-025-00941-6/."
}

\examples{
set.seed(1)
df <- data.frame(
  x1 = rnorm(20),
  x2 = rnorm(20),
  g  = factor(sample(letters[1:3], 20, TRUE))
)
fit <- gsom_Training(df, grid_rows = 3, grid_cols = 3,
                num_iterations = 5, batch_size = 4)
U <- gsom_Umatrix(fit$weights, n_rows = 3, n_cols = 3)
plot_Umatrix(U)
}
\seealso{\code{\link[cluster]{daisy}}}
