globaldecodeHMM <- function(x, HMM, obsdist){

  # Validate observation distribution
  if(!obsdist %in% c("pois", "norm", "weibull", "zip", "nbinom", "zinb", "exp", "gamma", "lnorm", "gev", "ZInormal", "ZIgamma")) {
    stop("observation distribution is not supported")
  }

  # Extract model parameters
  J <- length(HMM$estimate$delta)
  Pi <- HMM$estimate$Pi
  obspar <- HMM$estimate[1:(length(HMM$estimate)-2)]

  # Use stationary distribution for delta
  delta <- solve(t(diag(J)-Pi +1), rep(1,J))

  n <- length(x)
  obsprobs_matrix <- obsprobs(x, J, obsdist, obspar)

  # Forward pass: compute state probabilities
  mat <- matrix(0, n, J)
  alpha <- delta * obsprobs_matrix[1,]  # Initialize with prior and first observation
  mat[1,] <- alpha/sum(alpha)  # Normalize

  for(i in 2:n){
    alpha <- mat[i-1,] %*% Pi * obsprobs_matrix[i,]  # Transition and observation
    mat[i,] <- alpha/sum(alpha)  # Normalize
  }

  # Backward pass: find most likely path (Viterbi traceback)
  gd <- numeric(n)
  gd[n] <- which.max(mat[n,])  # Most likely final state

  for(i in (n-1):1){
    gd[i] <- which.max(Pi[,gd[i+1]]*mat[i,])  # Most likely predecessor
  }

  return(gd)
}






