params.w2n <- function(J, wparams, obsdist) {

  if (obsdist == "norm") {
    # Normal distribution: mean (unchanged), exp(log(sd))
    mean <- wparams[1:J]
    expparams <- exp(wparams)
    sd <- expparams[(J+1):(2*J)]
    # Reconstruct transition matrix from log-ratios
    Pi <- diag(J)
    Pi[!Pi] <- expparams[(2*J+1):length(wparams)]
    Pi <- Pi / apply(Pi, 1, sum)  # Normalize rows to sum to 1
    # Calculate stationary distribution
    delta <- solve(t(diag(J) - Pi + 1), rep(1, J))
    return(obspar = list(mean = mean, sd = sd, Pi = Pi, delta = delta))

  } else if (obsdist == "pois") {
    # Poisson distribution: exp(log(lambda))
    expparams <- exp(wparams)
    lambda <- expparams[1:J]
    Pi <- diag(J)
    Pi[!Pi] <- expparams[(J+1):length(expparams)]
    Pi <- Pi / apply(Pi, 1, sum)
    delta <- solve(t(diag(J) - Pi + 1), rep(1, J))
    return(obspar = list(lambda = lambda, Pi = Pi, delta = delta))

  } else if (obsdist == "weibull") {
    # Weibull distribution: exp(log(shape)), exp(log(scale))
    expparams <- exp(wparams)
    shape <- expparams[1:J]
    scale <- expparams[(J+1):(2*J)]
    Pi <- diag(J)
    Pi[!Pi] <- expparams[(2*J+1):length(expparams)]
    Pi <- Pi / apply(Pi, 1, sum)
    delta <- solve(t(diag(J) - Pi + 1), rep(1, J))
    return(obspar = list(shape = shape, scale = scale, Pi = Pi, delta = delta))

  } else if (obsdist == "zip") {
    # Zero-inflated Poisson: exp(log(lambda)), inverse logit for pi
    expparams <- exp(wparams)
    lambda <- expparams[1:J]
    pi <- expparams[(J + 1):(2 * J)] / (1 + expparams[(J + 1):(2 * J)])  # inverse logit
    Pi <- diag(J)
    Pi[!Pi] <- expparams[(2*J+1):length(expparams)]
    Pi <- Pi / apply(Pi, 1, sum)
    delta <- solve(t(diag(J) - Pi + 1), rep(1, J))
    return(obspar = list(lambda = lambda, pi = pi, Pi = Pi, delta = delta))

  } else if (obsdist == "nbinom") {
    # Negative binomial: exp(log(size)), exp(log(mu))
    expparams <- exp(wparams)
    size <- expparams[1:J]
    mu <- expparams[(J + 1):(2 * J)]
    Pi <- diag(J)
    Pi[!Pi] <- expparams[(2*J+1):length(expparams)]
    Pi <- Pi / apply(Pi, 1, sum)
    delta <- solve(t(diag(J) - Pi + 1), rep(1, J))
    return(obspar = list(size = size, mu = mu, Pi = Pi, delta = delta))

  } else if (obsdist == "zinb") {
    # Zero-inflated negative binomial: exp(log(size)), exp(log(mu)), inverse logit for pi
    expparams <- exp(wparams)
    size <- expparams[1:J]
    mu <- expparams[(J+1):(2*J)]
    pi <- expparams[(2*J+1):(3*J)] / (1 + expparams[(2*J+1):(3*J)])  # inverse logit
    Pi <- diag(J)
    Pi[!Pi] <- expparams[(3*J+1):length(expparams)]
    Pi <- Pi / apply(Pi, 1, sum)
    delta <- solve(t(diag(J) - Pi + 1), rep(1, J))
    return(obspar = list(size = size, mu = mu, pi = pi, Pi = Pi, delta = delta))

  } else if (obsdist == "exp") {
    # Exponential distribution: exp(log(rate))
    expparams <- exp(wparams)
    rate <- expparams[1:J]
    Pi <- diag(J)
    Pi[!Pi] <- expparams[(J+1):length(expparams)]
    Pi <- Pi / apply(Pi, 1, sum)
    delta <- solve(t(diag(J) - Pi + 1), rep(1, J))
    return(obspar = list(rate = rate, Pi = Pi, delta = delta))

  } else if (obsdist == "gamma") {
    # Gamma distribution: exp(log(shape)), exp(log(rate))
    expparams <- exp(wparams)
    shape <- expparams[1:J]
    rate <- expparams[(J+1):(2*J)]
    Pi <- diag(J)
    Pi[!Pi] <- expparams[(2*J+1):length(expparams)]
    Pi <- Pi / apply(Pi, 1, sum)
    delta <- solve(t(diag(J) - Pi + 1), rep(1, J))
    return(obspar = list(shape = shape, rate = rate, Pi = Pi, delta = delta))

  } else if (obsdist == "lnorm") {
    # Log-normal: meanlog (unchanged), exp(log(sdlog))
    meanlog <- wparams[1:J]
    expparams <- exp(wparams[(J+1):length(wparams)])
    sdlog <- expparams[1:J]
    Pi <- diag(J)
    Pi[!Pi] <- expparams[(J+1):length(expparams)]
    Pi <- Pi / apply(Pi, 1, sum)
    delta <- solve(t(diag(J) - Pi + 1), rep(1, J))
    return(obspar = list(meanlog = meanlog, sdlog = sdlog, Pi = Pi, delta = delta))

  } else if (obsdist == "gev") {
    # Generalized extreme value: loc (unchanged), exp(log(scale)), shape (unchanged)
    loc <- wparams[1:J]
    scale <- exp(wparams[(J+1):(2*J)])
    shape <- wparams[(2*J+1):(3*J)]
    Pi <- diag(J)
    Pi[!Pi] <- exp(wparams[(3*J+1):length(wparams)])
    Pi <- Pi / apply(Pi, 1, sum)
    delta <- solve(t(diag(J) - Pi + 1), rep(1, J))
    return(obspar = list(loc = loc, scale = scale, shape = shape, Pi = Pi, delta = delta))

  } else if(obsdist == "ZInormal"){
    # Zero-inflated normal: mean, exp(log(sd)), inverse logit for pi
    mean <- wparams[1:J]
    expparams <- exp(wparams)
    sd <- expparams[(J+1):(2*J)]
    pi <- expparams[(2*J+1):(3*J)] / (1 + expparams[(2*J+1):(3*J)])  # inverse logit
    Pi <- diag(J)
    Pi[!Pi] <- expparams[(3*J+1):length(expparams)]
    Pi <- Pi / apply(Pi, 1, sum)
    delta <- solve(t(diag(J) - Pi + 1), rep(1, J))
    return(obspar = list(mean = mean, sd = sd, pi = pi, Pi = Pi, delta = delta))

  } else if(obsdist == "ZIgamma"){
    # Zero-inflated gamma: exp(log(shape)), exp(log(rate)), inverse logit for pi
    expparams <- exp(wparams)
    shape <- expparams[(1:J)]
    rate <- expparams[(J+1):(2*J)]
    pi <- expparams[(2*J+1):(3*J)] / (1 + expparams[(2*J+1):(3*J)]) # inverse logit
    Pi <- diag(J)
    Pi[!Pi] <- expparams[(3*J+1):length(expparams)]
    Pi <- Pi/apply(Pi, 1, sum)
    delta <- solve(t(diag(J) - Pi + 1), rep(1, J))
    return(obspar = list(shape=shape, rate=rate, pi=pi, Pi=Pi, delta=delta))
  }
}
