% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fst_HapDip.R
\name{summarize_fst}
\alias{summarize_fst}
\title{Summarize genome-wide Fst per population pair}
\usage{
summarize_fst(fst_table)
}
\arguments{
\item{fst_table}{A [data.table::data.table] produced by [pairwise.fst()],
containing at minimum the columns \code{Pop_pair}, \code{Fst}, and
\code{Sum.Sites}.}
}
\value{
A [tibble::tibble] with one row per population pair and the
  following columns:
  \describe{
    \item{Pop_pair}{A character string identifying the population pair.}
    \item{wMean.Fst}{Weighted mean of Fst across all windows.}
    \item{wSD.Fst}{Weighted standard deviation of Fst across all windows.}
  }
}
\description{
Computes the site-count-weighted mean and standard deviation of Fst across
all windows for each population pair, using the per-window Fst table
produced by [pairwise.fst()]. Weighting by \code{Sum.Sites} ensures that
windows with more called genotypes contribute more to the estimate.
}
\examples{
vcf_path <- system.file("extdata",
                        "example.vcf",
                        package = "HaploDiploidEquilibrium")
result   <- vcf2GT(vcf_path)
gt       <- result$gt_matrix
contigs  <- result$contig_vector
pos      <- result$positions

pop.file <- data.frame(ID  = colnames(gt),
                       Pop = c("PopA","PopA","PopB","PopB","PopB"))

af <- allele.freq.WS(geno.data  = gt,
                     pop.file   = pop.file,
                     contigs    = contigs,
                     positions  = pos,
                     window.size = 10000)
fst <- pairwise.fst(af)
summary <- summarize_fst(fst)

}
\seealso{
[pairwise.fst()] for computing the input per-window Fst table.
}
