% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HaploDip_GenoFreq.R
\name{summarize_geno}
\alias{summarize_geno}
\title{Summarize per-window genotype frequencies per population}
\usage{
summarize_geno(geno_table)
}
\arguments{
\item{geno_table}{A [data.table::data.table] produced by
[compute_allele.freqs_W()], containing at minimum the columns
\code{Pop}, \code{N_sites}, \code{Exp.Het}, \code{Obs.Het},
\code{Exp.M.Ref}, and \code{Obs.M.Ref}.}
}
\value{
A [tibble::tibble] with one row per population and the following
  columns:
  \describe{
    \item{Pop}{Population label.}
    \item{wMean.Exp.Het}{Weighted mean of expected heterozygosity across
      all windows.}
    \item{wSD.Exp.Het}{Weighted standard deviation of expected
      heterozygosity across all windows.}
    \item{wMean.Obs.Het}{Weighted mean of observed heterozygosity across
      all windows.}
    \item{wSD.Obs.Het}{Weighted standard deviation of observed
      heterozygosity across all windows.}
    \item{wMean.Exp.M.Ref}{Weighted mean of expected haploid reference
      allele frequency across all windows.}
    \item{wSD.Exp.M.Ref}{Weighted standard deviation of expected haploid
      reference allele frequency across all windows.}
    \item{wMean.Obs.M.Ref}{Weighted mean of observed haploid reference
      allele frequency across all windows.}
    \item{wSD.Obs.M.Ref}{Weighted standard deviation of observed haploid
      reference allele frequency across all windows.}
  }
}
\description{
Computes the site-count-weighted mean and standard deviation of observed
and expected heterozygosity, and of observed and expected haploid reference
allele frequency, across all windows for each population. Uses the
per-window table produced by [compute_allele.freqs_W()]. Weighting by
\code{N_sites} ensures that windows with more called genotypes contribute
more to each estimate.
}
\examples{
vcf_path <- system.file("extdata",
                        "example.vcf",
                        package = "HaploDiploidEquilibrium")

result <- vcf2GT(vcf_path)
gt       <- result$gt_matrix
contigs  <- result$contig_vector
pos      <- result$positions

pop.file <- data.frame(ID  = colnames(gt),
                       Pop = c("PopA","PopA","PopB","PopB","PopB"))

geno <- compute_allele.freqs_W(geno.data   = gt,
                               pop.file    = pop.file,
                               contigs     = contigs,
                               positions   = pos,
                               window.size = 10000,
                               dip_freq    = 0.5)
summary <- summarize_geno(geno)

}
\seealso{
[compute_allele.freqs_W()] for computing the input per-window
  table.
}
