% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Haplo-Dip_Sex_Ref_Allele.R
\name{summarize_sex_ref}
\alias{summarize_sex_ref}
\title{Summarize per-sex reference allele frequencies per population}
\usage{
summarize_sex_ref(allele_table)
}
\arguments{
\item{allele_table}{A [data.table::data.table] produced by
[compute.Female.Male.allele.W()], containing at minimum the columns
\code{Pop}, \code{N_sites}, \code{Females.freq}, \code{Males.freq}, and
\code{Total.freq}.}
}
\value{
A [tibble::tibble] with one row per population and the following
  columns:
  \describe{
    \item{Pop}{Population label.}
    \item{wMean.F.Ref}{Weighted mean of the female reference allele
      frequency across all windows.}
    \item{wSD.F.Ref}{Weighted standard deviation of the female reference
      allele frequency across all windows.}
    \item{wMean.M.Ref}{Weighted mean of the male reference allele frequency
      across all windows.}
    \item{wSD.M.Ref}{Weighted standard deviation of the male reference
      allele frequency across all windows.}
    \item{wMean.T.Ref}{Weighted mean of the combined reference allele
      frequency across all windows.}
    \item{wSD.T.Ref}{Weighted standard deviation of the combined reference
      allele frequency across all windows.}
  }
}
\description{
Computes the site-count-weighted mean and standard deviation of the
reference allele frequency for females, males, and both sexes combined,
across all windows for each population. Uses the per-window table produced
by [compute.Female.Male.allele.W()]. Weighting by \code{N_sites} ensures
that windows with more called genotypes contribute more to each estimate.
}
\examples{
vcf_path <- system.file("extdata",
                        "example.vcf",
                        package = "HaploDiploidEquilibrium")
result <- vcf2GT(vcf_path)
gt       <- result$gt_matrix
contigs  <- result$contig_vector
pos      <- result$positions

pop.file <- data.frame(ID  = colnames(gt),
                       Pop = c("PopA","PopA","PopB","PopB","PopB"))

sex_ref <- compute.Female.Male.allele.W(geno.data   = gt,
                                        pop.file    = pop.file,
                                        contigs     = contigs,
                                        positions   = pos,
                                        window.size = 10000)
summary <- summarize_sex_ref(sex_ref)

}
\seealso{
[compute.Female.Male.allele.W()] for computing the input
  per-window table.
}
