% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{vcf2GT}
\alias{vcf2GT}
\title{Import a VCF file and extract genotype and positional data}
\usage{
vcf2GT(path_to_vcf)
}
\arguments{
\item{path_to_vcf}{A length-one character string giving the path to the
input VCF file.}
}
\value{
A named list with three elements:
  \describe{
    \item{contig_vector}{A character vector of length \code{n_sites}
      containing the contig (chromosome) name for each variant.}
    \item{positions}{A numeric vector of length \code{n_sites} containing
      the physical position (bp) of each variant.}
    \item{gt_matrix}{A character matrix of genotype strings with dimensions
      \code{n_sites x n_individuals} (e.g. \code{"0/0"}, \code{"0/1"},
      \code{"1"}). Row names are inherited from the VCF variant records and
      column names correspond to sample identifiers in the VCF header.}
  }
}
\description{
Reads a VCF file from disk and extracts three pieces of information: the
genotype calls (the \code{GT} field), the contig (chromosome) name for each
variant site, and its physical position. These are the three inputs required
by the windowed summary-statistic functions in this package.
}
\examples{
vcf_path <- system.file("extdata",
                        "example.vcf",
                        package = "HaploDiploidEquilibrium")

result <- vcf2GT(vcf_path)

head(result$contig_vector)
head(result$positions)
head(result$gt_matrix)

}
\seealso{
[vcfR::read.vcfR()] for full control over VCF parsing options.
}
