% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_iblm.R
\name{beta_corrections_derive}
\alias{beta_corrections_derive}
\title{Compute Beta Corrections based on SHAP values}
\usage{
beta_corrections_derive(
  shap_wide,
  wide_input_frame,
  iblm_model,
  migrate_reference_to_bias = TRUE
)
}
\arguments{
\item{shap_wide}{Data frame containing SHAP values from XGBoost that have been converted to wide format by [shap_to_onehot()]}

\item{wide_input_frame}{Wide format input data frame (one-hot encoded).}

\item{iblm_model}{Object of class 'iblm'}

\item{migrate_reference_to_bias}{Logical, migrate the beta corrections to the bias for reference levels?
This applied to categorical vars only. It is recommended to leave this setting on TRUE}
}
\value{
A data frame with the booster model beta corrections in one-hot (wide) format
}
\description{
Processes SHAP values in one-hot (wide) format to create beta coefficient corrections.

This includes:
\itemize{
  \item scaling shap values of continuous variables by the predictor value for that row
  \item migrating shap values to the bias for continuous variables where the predictor value was zero
  \item migrating shap values to the bias for categorical variables where the predictor value was reference level
}
}
\examples{
df_list <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  df_list,
  response_var = "ClaimRate",
  family = "poisson"
)

shap <- extract_booster_shap(iblm_model$booster_model, df_list$test)

wide_input_frame <- data_to_onehot(df_list$test, iblm_model)

shap_wide <- shap_to_onehot(shap, wide_input_frame, iblm_model)

beta_corrections <- beta_corrections_derive(shap_wide, wide_input_frame, iblm_model)

beta_corrections |> dplyr::glimpse()

}
