% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Compute_Dantzig_GUROBI2.R
\name{dantzig_missing}
\alias{dantzig_missing}
\title{Dantzig estimator with missing covariates}
\usage{
dantzig_missing(
  X_labeled, y, X_unlabeled = NULL, lambda,
  gurobi = FALSE, standardise = TRUE
)
}
\arguments{
\item{X_labeled}{Numeric matrix or data.frame of labelled covariates, with rows corresponding
to observations and columns to covariates. Missing values are allowed.}

\item{y}{Numeric response vector of length \code{nrow(X_labeled)}.}

\item{X_unlabeled}{Optional numeric matrix or data.frame of unlabelled covariates. If supplied,
these observations are used only for estimating second moments of the
covariates and do not contribute to the response.}

\item{lambda}{Positive numeric scalar giving the Dantzig regularisation parameter.}

\item{gurobi}{Logical; if TRUE, the linear programs are solved using the \pkg{gurobi}
optimizer (a valid Gurobi installation and license are required). If FALSE,
the open-source solver from \pkg{Rglpk} is used instead.}

\item{standardise}{Logical; if TRUE, covariates are standardised prior to estimation and the
resulting coefficients are mapped back to the original scale with an
intercept term returned.}
}
\value{
A list with at least the following component:
\describe{
\item{beta_hat}{Numeric vector of estimated regression coefficients, with
names corresponding to the encoded design matrix columns.}
}
If \code{standardise = TRUE}, the list also contains:
\describe{
\item{intercept}{Numeric scalar giving the estimated intercept term.}
}
}
\description{
High-dimensional linear regression estimator based on the Dantzig selector
that accommodates missing covariates and optionally leverages unlabelled
covariate data. This function is a user-facing wrapper that dispatches to
either a standardised or unstandardised implementation depending on the
value of \code{standardise}. This function is based on
Section 3 of \insertCite{RisebrowSSLR;textual}{LRMiss}.
}
\details{
Categorical covariates are internally dummy-encoded, with missing values
preserved. When \code{standardise = TRUE}, covariates are centred and scaled
using empirical means and standard deviations computed from the combined
labelled and unlabelled samples.
}
\examples{
set.seed(1)
n <- 50; p <- 5
X_full <- matrix(rnorm(n * p), n, p)
beta_true <- c(1, 0.5, rep(0, p - 2))
y <- X_full[, 1] * beta_true[1] + X_full[, 2] * beta_true[2] + rnorm(n)

# introduce missingness into covariates
X_miss <- X_full
X_miss[sample(length(X_miss), size = 0.1 * length(X_miss))] <- NA

# fit Dantzig estimator (example lambda; tune in practice)
fit <- dantzig_missing(
  X_labeled = X_miss,
  y = y,
  lambda = 0.1,
  standardise = TRUE
)
fit$beta_hat

}
\references{
\insertRef{RisebrowSSLR}{LRMiss}
}
