LSMstarts=function(X,ndim_z,J,nc,random=FALSE,silent=TRUE){
  random_starts=random
  N=nrow(X)
  nit=ncol(X)
  if(ndim_z==0) random_starts=TRUE
  if(random_starts==FALSE){
    random_starts1=FALSE
    model=paste0(c("t=~",paste(paste0("1*X",1:nit),collapse="+")),collapse="")
    for(s in 1:ndim_z){
      if(s<ndim_z) model=c(model,paste0(c("s",s,"=~",paste(paste0("0",paste0("*X",1:s)),collapse="+"),paste(paste0("+X",(s+1):nit),collapse="")),collapse=""))
      if(s==ndim_z) model=c(model,paste0(c("s",s,"=~NA*",paste(paste0("X",1:nit),collapse="+")),collapse=""))
      model=c(model,paste0("s",s,"~~1*","s",s,collapse=""))
    }
    Xdat=X
    colnames(Xdat)=paste0("X",1:nit)
    if(silent==FALSE) cat("Fitting factor model to obtain starting values...\r")
    lav_warnings=list()
    lav_warn=NULL
    res<-withCallingHandlers(lavaan::cfa(model,Xdat,ordered=TRUE,orthogonal=TRUE,warn=FALSE),warning = function(w) {
      lav_warn <<- TRUE
      lav_warnings <<- c(lav_warnings, list(w))
      invokeRestart("muffleWarning")  # prevents warning from printing to console
    })
    if(lavaan::lavInspect(res,what="optim")$converged==FALSE) random_starts=TRUE
    if(lavaan::lavInspect(res,what="optim")$converged==TRUE){
      if(lavaan::coef(res)["t~~t"]<0) random_starts=TRUE
      if(TRUE%in%(abs(lavaan::inspect(res,what="est")$lambda[,2:(ndim_z+1)])>1)) random_starts=TRUE
      if(withCallingHandlers(lavaan::lavInspect(res,"post.check")==FALSE,warning=function(w) invokeRestart("muffleWarning") )) random_starts=TRUE
    }
  }
  if(random_starts==FALSE){
      fs_start=lavaan::predict(res)
      z_start=matrix(,N,ndim_z)
      z_start[stats::complete.cases(X),]=fs_start[,-1]
      var_t=lavaan::coef(res)["t~~t"]
      t_start=matrix(,N)
      t_start[stats::complete.cases(X)]=fs_start[,1]/ (1.7*sqrt(var_t))
      if(ndim_z>1) scale=sqrt(1-var_t-apply(lavaan::inspect(res,what="est")$lambda[,2:(ndim_z+1)]^2,1,sum))
      if(ndim_z==1) scale=sqrt(1-var_t-lavaan::inspect(res,what="est")$lambda[,2:(ndim_z+1)]^2)
      w_start=1.7*lavaan::inspect(res,what="est")$lambda[,2:(ndim_z+1)]/scale
      b_start=1.7*lavaan::inspect(res,what="est")$tau[,1]/apply(scale*J,2,sum)
      if(ndim_z==1) w_start=matrix(w_start)

      if(length(which(stats::complete.cases(X)))<N){
        miss_id=which(!stats::complete.cases(X))
        for(p in 1:length(miss_id)){
          ind=which(order(rowSums(X,na.rm=TRUE))==miss_id[p])
          while(is.na(t_start[miss_id[p]]) & (ind+1)<=N){
              ind=ind+1
              t_start[miss_id[p]]=t_start[order(rowSums(X,na.rm=TRUE))[ind]]
              z_start[miss_id[p],]=z_start[order(rowSums(X,na.rm=TRUE))[ind],]
            }
          if((ind+1)>N){
            while(is.na(t_start[miss_id[p]])){
              ind=ind-1
              t_start[miss_id[p]]=t_start[order(rowSums(X,na.rm=TRUE))[ind]]
              z_start[miss_id[p],]=z_start[order(rowSums(X,na.rm=TRUE))[ind],]
            }
          }
        }
      }
      dist=0
      for(s in 1:ndim_z) dist=dist+kronecker(matrix(z_start[,s]),t(matrix(w_start[,s])),FUN = "-")^2
      b_start=matrix(-b_start+apply(sqrt(dist),2,mean)%*%J)
      } else{
        if((random!=random_starts)&ndim_z>0) warning("Issues in fitting a ",ndim_z+1,"-factor model to your data. Shifted to random starting values.")
        if((random!=random_starts)&ndim_z==0) warning("For ndim_z=0, no random starting values will be generated.")
        t_start=matrix(stats::rnorm(N,0,1))
        b_start=c()
        for(i in 1:length(nc)){
          if(i>1) b_start[(sum(nc[1:(i-1)]-1)+1):(sum(nc[1:i]-1))]=-sort(stats::rnorm(nc[i]-1,0,1))
          if(i==1) b_start[1:(nc[i]-1)]=-sort(stats::rnorm(nc[i]-1,0,1))
        }
        b_start=matrix(b_start)
        z_start=matrix(,N,ndim_z)
        w_start=matrix(,nit,ndim_z)
        if(ndim_z>0){
          for(s in 1:ndim_z){
            z_start[,s]=stats::rnorm(N,0,1)
            w_start[,s]=stats::rnorm(nit,0,1)
          }
          if(ndim_z>1) for(s1 in 1:(ndim_z-1)) for(s2 in 1:(ndim_z-1)) if(s2<=s1) w_start[s2,s1]=0
        }
        if(ndim_z==0){
            z_start=matrix(rep(0,N))
            w_start=matrix(rep(0,nit))
          }
      }
     return(list(theta0=t_start,b0=b_start,z0=z_start,w0=w_start))
}

LSMstartsML=function(X,ndim_z,J,nc,random=FALSE,silent=TRUE){
  random_starts=random
  N=nrow(X)
  nit=ncol(X)
  if(ndim_z==0) random_starts=TRUE
  if(random_starts==FALSE){
    random_starts1=FALSE
    model=paste0(c("t=~",paste(paste0("1*X",1:nit),collapse="+")),collapse="")
    for(s in 1:ndim_z){
      if(s<ndim_z) model=c(model,paste0(c("s",s,"=~",paste(paste0("0",paste0("*X",1:s)),collapse="+"),paste(paste0("+X",(s+1):nit),collapse="")),collapse=""))
      if(s==ndim_z) model=c(model,paste0(c("s",s,"=~NA*",paste(paste0("X",1:nit),collapse="+")),collapse=""))
      model=c(model,paste0("s",s,"~~1*","s",s,collapse=""))
    }
    Xdat=X
    colnames(Xdat)=paste0("X",1:nit)
    if(silent==FALSE) cat("Fitting factor model to obtain starting values...\r")
    if(length(unique(nc))!=1) global=FALSE else global=TRUE
    poly_warnings=list()
    poly_warn=NULL
    rho = withCallingHandlers(psych::polychoric(X,global=global),warning = function(w) {
       poly_warn <<- TRUE
       poly_warnings <<- c(poly_warnings, list(w))
       invokeRestart("muffleWarning")  # prevents warning from printing to console
      })
    tau=rho$tau
    rho=rho$rho
    colnames(rho)=rownames(rho)=paste0("X",1:nit)
    lav_warnings=list()
    lav_warn=NULL
    res<-withCallingHandlers(lavaan::cfa(model,sample.cov = rho,sample.nobs=N,orthogonal=TRUE,warn=FALSE),warning = function(w) {
      lav_warn <<- TRUE
      lav_warnings <<- c(lav_warnings, list(w))
      invokeRestart("muffleWarning")  # prevents warning from printing to console
    })
    if(lavaan::lavInspect(res,what="optim")$converged==FALSE) random_starts=TRUE
    if(lavaan::lavInspect(res,what="optim")$converged==TRUE){
      if(lavaan::coef(res)["t~~t"]<0) random_starts=TRUE
      if(TRUE%in%(abs(lavaan::inspect(res,what="est")$lambda[,2:(ndim_z+1)])>1)) random_starts=TRUE
      if(withCallingHandlers(lavaan::lavInspect(res,"post.check")==FALSE,warning=function(w) invokeRestart("muffleWarning") )) random_starts=TRUE
    }
  }
  if(random_starts==FALSE){
    fs_start=lavaan::predict(res,Xdat)
    z_start=matrix(,N,ndim_z)
    z_start[stats::complete.cases(X),]=fs_start[,-1]
    var_t=lavaan::coef(res)["t~~t"]
    t_start=matrix(,N)
    t_start[stats::complete.cases(X)]=fs_start[,1]/ (1.7*sqrt(var_t))
    if(ndim_z>1) scale=sqrt(1-var_t-apply(lavaan::inspect(res,what="est")$lambda[,2:(ndim_z+1)]^2,1,sum))
    if(ndim_z==1) scale=sqrt(1-var_t-lavaan::inspect(res,what="est")$lambda[,2:(ndim_z+1)]^2)
    w_start=1.7*lavaan::inspect(res,what="est")$lambda[,2:(ndim_z+1)]/scale
    if(length(t(tau)[is.finite(t(tau))])==sum(nc-1))
      b_start=1.7*t(tau)[is.finite(t(tau))]/apply(scale*J,2,sum)
    if(length(t(tau)[is.finite(t(tau))])!=sum(nc-1)){
      b_start=c()
      for(j in 1:nrow(tau)) b_start=c(b_start,tau[j,1:(nc[j]-1)])
      b_start=1.7*b_start/apply(scale*J,2,sum)
    }
    if(ndim_z==1) w_start=matrix(w_start)

    if(length(which(stats::complete.cases(X)))<N){
      miss_id=which(!stats::complete.cases(X))
      for(p in 1:length(miss_id)){
        ind=which(order(rowSums(X,na.rm=TRUE))==miss_id[p])
        while(is.na(t_start[miss_id[p]]) & (ind+1)<=N){
          ind=ind+1
          t_start[miss_id[p]]=t_start[order(rowSums(X,na.rm=TRUE))[ind]]
          z_start[miss_id[p],]=z_start[order(rowSums(X,na.rm=TRUE))[ind],]
        }
        if((ind+1)>N){
          while(is.na(t_start[miss_id[p]])){
            ind=ind-1
            t_start[miss_id[p]]=t_start[order(rowSums(X,na.rm=TRUE))[ind]]
            z_start[miss_id[p],]=z_start[order(rowSums(X,na.rm=TRUE))[ind],]
          }
        }
      }
    }
    dist=0
    for(s in 1:ndim_z) dist=dist+kronecker(matrix(z_start[,s]),t(matrix(w_start[,s])),FUN = "-")^2
    b_start=matrix(-b_start+apply(sqrt(dist),2,mean)%*%J)
  } else{
    if((random!=random_starts)&ndim_z>0) warning("Issues in fitting a ",ndim_z+1,"-factor model to your data. Shifted to random starting values.")
    if((random!=random_starts)&ndim_z==0) warning("For ndim_z=0, random starting values are generated.")
    t_start=matrix(stats::rnorm(N,0,1))
    b_start=c()
    for(i in 1:length(nc)){
      if(i>1) b_start[(sum(nc[1:(i-1)]-1)+1):(sum(nc[1:i]-1))]=-sort(stats::rnorm(nc[i]-1,0,1))
      if(i==1) b_start[1:(nc[i]-1)]=-sort(stats::rnorm(nc[i]-1,0,1))
    }
    b_start=matrix(b_start)
    z_start=matrix(,N,ndim_z)
    w_start=matrix(,nit,ndim_z)
    if(ndim_z>0){
      for(s in 1:ndim_z){
        z_start[,s]=stats::rnorm(N,0,1)
        w_start[,s]=stats::rnorm(nit,0,1)
      }
      if(ndim_z>1) for(s1 in 1:(ndim_z-1)) for(s2 in 1:(ndim_z-1)) if(s2<=s1) w_start[s2,s1]=0
    }
    if(ndim_z==0){
      z_start=matrix(rep(0,N))
      w_start=matrix(rep(0,nit))
    }
  }
  return(list(theta0=t_start,b0=b_start,z0=z_start,w0=w_start))
}
