# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Find test statistic of Fasano–Franceschini test
#' @param dta data matrix
#' @return  a test statistic
#' @keywords internal
FF <- function(dta) {
    .Call(`_MDgof_FF`, dta)
}

#' Find test statistics for continuous data
#' 
#' @param x A numeric matrix.
#' @param pnull cdf.
#' @param param parameters for pnull  in case of parameter estimation.
#' @param TSextra list with additional info
#' @return A numeric vector with test statistics
#' @export
TS_cont <- function(x, pnull, param, TSextra) {
    .Call(`_MDgof_TS_cont`, x, pnull, param, TSextra)
}

#' Find test statistics for discrete data
#' 
#' @param x A numeric matrix.
#' @param pnull cdf.
#' @param param parameters for pnull  in case of parameter estimation.
#' @param TSextra list with additional info
#' @return A numeric vector with test statistics
#' @export
TS_disc <- function(x, pnull, param, TSextra) {
    .Call(`_MDgof_TS_disc`, x, pnull, param, TSextra)
}

#' Find evaluation points
#'
#' @param rnull, a function that generate new data.
#' @param p, a vector of parameters for rnull.
#' @param m, size of matrix.
#' @return a matrix
#' 
gen_eval <- function(rnull, p, m) {
    .Call(`_MDgof_gen_eval`, rnull, p, m)
}

#' Find gaussian kernel pdf
#' 
#' @param Eval a matrix.
#' @param S a matrix
#' @param h bandwith, a double
#' @return a matrix
#' 
gauss_kernel_matrix <- function(Eval, S, h) {
    .Call(`_MDgof_gauss_kernel_matrix`, Eval, S, h)
}

#' Estimate E and Var/n at Eval for given h, using MC from rnull
#' 
#' @param rnull generate data under the null hypothesis.
#' @param p values for rnull
#' @param Eval matrix of evaluations
#' @param h bandwith, a double
#' @param nsim_mc number of simulation runs
#' @param n sample size
#' @return a matrix
#'
estimateEV <- function(rnull, p, Eval, h, nsim_mc, n) {
    .Call(`_MDgof_estimateEV`, rnull, p, Eval, h, nsim_mc, n)
}

#' Compute M statistic for one dtaset
#' 
#' @param dta data matrix.
#' @param Eval matrix of evaluations
#' @param hs bandwiths
#' @param rnull generate new data
#' @param p values for parametric bootstrap
#' @param nsim_mc number of simulation runs
#' @return a double
#'
compute_M_for_dtaset <- function(dta, Eval, hs, rnull, p, nsim_mc) {
    .Call(`_MDgof_compute_M_for_dtaset`, dta, Eval, hs, rnull, p, nsim_mc)
}

#' Run Bakshaev and Rudzkis Test
#' 
#' @param dta data matrix.
#' @param rnull generate new data.
#' @param p , parameters for parametric bootstrap.
#' @param m_eval =100, number of evaluation points of kde.
#' @param nsim =200, number of simulation runs.
#' @param nsim_mc =1000, number of simulation runs.
#' @return a list
#'
bakshaev_rudzkis <- function(dta, rnull, p, m_eval = 100L, nsim = 200L, nsim_mc = 1000L) {
    .Call(`_MDgof_bakshaev_rudzkis`, dta, rnull, p, m_eval, nsim, nsim_mc)
}

#' This function calculates the test statistics for  data
#' @param  dta data set (a matrix)
#' @param  TS routine
#' @param  typeTS format of TS
#' @param  TSextra list passed to TS function
#' @keywords internal
#' @return A vector of values of test statistic(s)
calcTS <- function(dta, TS, typeTS, TSextra) {
    .Call(`_MDgof_calcTS`, dta, TS, typeTS, TSextra)
}

#' Bins continuous data
#' 
#' @param x A numeric matrix with two columns.
#' @param nbins number of bins.
#' @param Range range of variables
#' @param ChangeVals =FALSE, should values of discrete rv's be adjusted to midpoints?
#' @return A numeric matrix
#' @export
discretize <- function(x, Range, nbins, ChangeVals = FALSE) {
    .Call(`_MDgof_discretize`, x, Range, nbins, ChangeVals)
}

#' Find test statistic for Kernel Stein Discrepancy test
#'
#' @param X data set.
#' @param scf function to find scores 
#' @param p (possible) parameters
#' @return a double (test statistic)
#' 
ksd <- function(X, scf, p) {
    .Call(`_MDgof_ksd`, X, scf, p)
}

#' Finds the empirical distribution function
#' @param dta a matrix of data points
#' @param pts a matrix of evaluation points
#' @keywords internal
#' @return a numeric vector
mdecdf <- function(dta, pts) {
    .Call(`_MDgof_mdecdf`, dta, pts)
}

#' Find gradient of log(f) 
#' @param x point of evaluation
#' @param f function 
#' @return  a gradient vector
#' @keywords internal
grad_vec <- function(x, f) {
    .Call(`_MDgof_grad_vec`, x, f)
}

#' Find gradient of log(f) for a matrix of points
#' @param x point of evaluation
#' @param f function 
#' @return  a matrix of gradient vectors
grad_mat <- function(x, f) {
    .Call(`_MDgof_grad_mat`, x, f)
}

#' R function order(x,y) for Rcpp
#' 
#' @param x first vector
#' @param y second vector
#' @return  a vector of integers
#' @keywords  internal
orderC <- function(x, y) {
    .Call(`_MDgof_orderC`, x, y)
}

#' Find probabilities from cdf for discrete data
#' 
#' @param  x matrix with data
#' @param  cdf  function to find distribution function
#' @param  p (possible) arguments for cdf
#' @param  Fx (if available) already calculated values of cdf
#' @return a matrix with probabilities added
#' @export
p2dC <- function(x, cdf, p, Fx = as.numeric( c(-1))) {
    .Call(`_MDgof_p2dC`, x, cdf, p, Fx)
}

#' find power of gof tests for continuous data
#' 
#' @param rnull R function (generate data under null hypothesis)
#' @param ralt  R function to generate data under alternative
#' @param param_alt parameters of ralt
#' @param TS function to calculate test statistics
#' @param typeTS integer indicating type of test statistic
#' @param TSextra list to pass to TS
#' @param B  =1000 Number of simulation runs
#' @keywords internal
#' @return A matrix of powers
powerC <- function(rnull, ralt, param_alt, TS, typeTS, TSextra, B = 1000L) {
    .Call(`_MDgof_powerC`, rnull, ralt, param_alt, TS, typeTS, TSextra, B)
}

#' This function performs a Rosenblatt transform
#' @param  x data set (a matrix)
#' @param  cdf distribution function
#' @param  p (possible) parameters for cdf
#' @param  Range matrix with range of data
#' @keywords internal
#' @return A matrix of transformed data
rosenblattC <- function(x, cdf, p, Range) {
    .Call(`_MDgof_rosenblattC`, x, cdf, p, Range)
}

#' run gof tests for continuous data
#' 
#' @param dta A numeric matrix of data
#' @param rnull R function (generate data under null hypothesis)
#' @param TS function that calculates test statistics
#' @param typeTS integer indicating type of test statistic
#' @param TSextra list to pass to TS
#' @param B (=5000) Number of simulation runs 
#' @keywords internal
#' @return A matrix of numbers (test statistics and p values)
testC <- function(dta, rnull, TS, typeTS, TSextra, B = 5000L) {
    .Call(`_MDgof_testC`, dta, rnull, TS, typeTS, TSextra, B)
}

