% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MEGB.R
\name{simLong}
\alias{simLong}
\title{Simulate Low/High Dimensional and Linear/Nonlinear Longitudinal dataset.}
\usage{
simLong(
  n,
  p,
  rel_p = 6,
  time_points,
  rho_W = 0.5,
  rho_Z = 0.5,
  random_sd_intercept = 2,
  random_sd_slope = 1,
  noise_sd = 1,
  linear = TRUE
)
}
\arguments{
\item{n}{[numeric]: Number of individuals.}

\item{p}{[numeric]: Number of predictors.}

\item{rel_p}{[numeric]: Number of relevant predictors (true predictors that are correlated to the outcome.). The default value is \code{rel_p=6} if linear and \code{rel_p=2} if nonlinear.}

\item{time_points}{[numeric]: Number of realizations per individual.  The default value is \code{time_points=10}.}

\item{rho_W}{[numeric]: Within subject correlation. The default value is \code{rho_W=0.5}.}

\item{rho_Z}{[numeric]: Correlation between intercept and slope for the random effect coefficients. The default value is \code{rho_Z=0.5}.}

\item{random_sd_intercept}{[numeric]: Standard deviation for the random intercept. The default value is \code{random_sd_intercept=}\eqn{\sqrt{0.5}}.}

\item{random_sd_slope}{[numeric]: Standard deviation for the random slope. The default value is \code{random_sd_slope=}\eqn{\sqrt{3}}.}

\item{noise_sd}{[numeric]: Standard deviation for the random slope. The default value is \code{noise_sd=0.5}.}

\item{linear}{[boolean]: If TRUE, a linear mixed effect model is simulated, if otherwise, a semi-parametric model similar to the one used in Capitaine et al. (2021).}
}
\value{
a dataframe of dimension (n*time_points) by (p+5) containing the following elements: \itemize{
\item \code{id:} vector of the individual IDs.
\item \code{time:} vector of the time realizations.
\item \code{Y:} vector of the outcomes variable.
\item \code{RandomIntercept:} vector of the Random Intercept.
\item \code{RandomSlope:} vector of the Random Slope.
\item \code{Vars :} Remainder columns corresponding to the fixed effect variables.
}
}
\description{
Simulate p-dimensional linear/Nonlinear mixed-effects model given by: \deqn{Y_i(t)=f(X_i(t))+Z_i(t)\beta_i+\epsilon_i}
with \eqn{Y_i(t)} the output at time \eqn{t} for the \eqn{i}th individual; \eqn{X_i(t)} the input predictors (fixed effects) at time \eqn{t} for the \eqn{i}th individual;
\eqn{Z_i(t)} are the random effects at time \eqn{t} for the \eqn{i}th individual; \eqn{\epsilon_i} is the residual error with
variance \eqn{\sigma^2}. If linear, \eqn{f(X_i(t)) = X_i(t)\theta}, where \eqn{\theta = 1, \forall p}, otherwise if nonlinear, the
approach by Capitaine et al. (2021) is adapted.
}
\examples{
set.seed(1)
data = simLong(n = 17,p = 6,rel_p = 6,time_points = 10,rho_W = 0.6, rho_Z=0.6,
              random_sd_intercept = sqrt(0.5),
              random_sd_slope = sqrt(3),
              noise_sd = 0.5,linear=FALSE) # Generate the data
head(data)   # first six rows of the data.
# Let's see the output :
w <- which(data$id==1)
plot(data$time[w],data$Y[w],type="l",ylim=c(min(data$Y),max(data$Y)), col="grey")
for (i in unique(data$id)){
  w <- which(data$id==i)
  lines(data$time[w],data$Y[w], col='grey')
}
# Let's see the fixed effects predictors:
oldpar <- par(no.readonly = TRUE)
oldopt <- options()
par(mfrow=c(2,3), mar=c(2,3,3,2))
for (i in 1:ncol(data[,-1:-5])){
  w <- which(data$id==1)
  plot(data$time[w],data[,-1:-5][w,i], col="grey",ylim=c(min(data[,-1:-5][,i]),
  max(data[,-1:-5][,i])),xlim=c(1,max(data$time)), main = substitute(X^{(i)}, list(i = i)))
  for (k in unique(data$id)){
    w <- which(data$id==k)
    lines(data$time[w],data[,-1:-5][w,i], col="grey")
  }
}
par(oldpar)
options(oldopt)

}
