% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_single_t.R
\name{d_single_t}
\alias{d_single_t}
\alias{d.single.t}
\title{Cohen's d for One-Sample t from Summary Stats}
\usage{
d_single_t(m, u, sd, n, a = 0.05)

d.single.t(m, u, sd, n, a = 0.05)
}
\arguments{
\item{m}{Sample mean.}

\item{u}{Population (reference) mean \eqn{\mu}.}

\item{sd}{Sample standard deviation \eqn{s}.}

\item{n}{Sample size \eqn{n}.}

\item{a}{Significance level (alpha) for the confidence interval.
Must be in (0, 1).}
}
\value{
A list with the following elements:
\describe{
  \item{d}{Cohen's \eqn{d}.}
  \item{dlow}{Lower limit of the \eqn{(1-\alpha)} confidence
interval for \eqn{d}.}
  \item{dhigh}{Upper limit of the \eqn{(1-\alpha)} confidence
interval for \eqn{d}.}
  \item{m}{Sample mean.}
  \item{sd}{Sample standard deviation.}
  \item{se}{Standard error of the mean.}
  \item{Mlow, Mhigh}{Confidence interval bounds for the mean.}
  \item{u}{Population (reference) mean.}
  \item{n}{Sample size.}
  \item{df}{Degrees of freedom (\eqn{n - 1}).}
  \item{t}{t-statistic.}
  \item{p}{p-value.}
  \item{estimate}{APA-style formatted string for reporting
\eqn{d} and its CI.}
  \item{statistic}{APA-style formatted string for reporting
the t-statistic and p-value.}
}
}
\description{
**Note on function and output names:**
This effect size is now implemented with the snake_case function name
`d_single_t()` to follow modern R style guidelines. The original dotted
version `d.single.t()` is still available as a wrapper for backward
compatibility, and both functions return the same list. The returned
object includes both the original element names (e.g., `d`, `dlow`,
`dhigh`, `m`, `sd`, `se`, `Mlow`, `Mhigh`, `u`, `n`, `df`, `t`, `p`,
`estimate`, `statistic`) and newer snake_case aliases (e.g.,
`d_lower_limit`, `d_upper_limit`, `mean_value`, `sd_value`,
`se_value`, `mean_lower_limit`, `mean_upper_limit`, `population_mean`,
`sample_size`, `degrees_freedom`, `t_value`, `p_value`).
New code should prefer `d_single_t()` and the snake_case output
names, but existing code using the older names will continue to work.
}
\details{
Compute Cohen's \eqn{d} and a noncentral-t confidence interval for a
one-sample (single) t-test using summary statistics.


The effect size is defined as the standardized mean difference between the
sample mean and the population/reference mean:
\deqn{d = \frac{m - \mu}{s}.}

The corresponding t-statistic is:
\deqn{t = \frac{m - \mu}{s/\sqrt{n}}.}

See the online example for additional context:
\href{https://www.aggieerin.com/shiny-server/tests/singletm.html}{Learn more on our example page.}
}
\examples{
# Example derived from the "singt_data" dataset included in MOTE.

# A school claims their gifted/honors program outperforms the national
# average (1080). Their students' SAT scores (sample) have mean 1370 and
# SD 112.7.

    gift <- t.test(singt_data$SATscore, mu = 1080, alternative = "two.sided")

# Direct entry of summary statistics:
    d_single_t(m = 1370, u = 1080, sd = 112.7, n = 14, a = .05)

# Equivalent shorthand:
    d_single_t(1370, 1080, 112.7, 14, .05)

# Using values from the t-test object and dataset:
    d_single_t(gift$estimate, gift$null.value,
               sd(singt_data$SATscore), length(singt_data$SATscore), .05)
}
\keyword{effect}
\keyword{mean}
\keyword{one-sample}
\keyword{population}
\keyword{sample}
\keyword{single}
\keyword{size}
\keyword{t}
