\name{MaxInt_data_analysis}
\alias{MaxInt_data_analysis}
\title{
Permutation-Based Inference and Interaction Estimation for Maximal Interaction Two-Mode Clustering
}
\description{
Performs permutation-based statistical inference for the REMAXINT and E-ReMI biclustering models across multiple combinations of row and column clusters. 
It computes test statistics, p-values, critical values, and estimates interaction parameters for each specified combination of clusters. 
Furthermore, it provides us optimal row and column partitioning structure for REMAXINT and E-ReMI biclustering methods.  
}
\usage{
MaxInt_data_analysis(Data, Clus, Nruns, permutations, alpha_level, verbose = TRUE)
}
\arguments{
  \item{Data}{
A numeric matrix of dimension \code{I x J}, representing the data to be analyzed, where rows correspond to observations (e.g., participants) and columns to variables (e.g., tasks or conditions).
}
  \item{Clus}{
A matrix with two columns specifying the combinations of row clusters (\eqn{P}) and column clusters (\eqn{Q}) to be analyzed. Each row represents one (\eqn{P,Q}) combination.
}
  \item{Nruns}{
An integer specifying the number of independent runs for the REMAXINT and E-ReMI algorithms for each (\eqn{P,Q}) combination.
}
  \item{permutations}{
An integer specifying the number of permutations used to compute the empirical null distribution for test statistics.
}
  \item{alpha_level}{
Significance level (e.g., 0.05) for computing critical values from the permutation distribution.
}
  \item{verbose}{
Logical. If \code{TRUE} (default), progress messages are printed to the console during execution. 
Set to \code{FALSE} to suppress messages. Messages can also be suppressed using \code{suppressMessages()}.
}
}
\details{
The function iterates over all specified (\eqn{P,Q}) cluster combinations, applies the \code{Permutation_Function} for each combination, and stores the resulting test statistics, 
p-values, critical values, and estimated interaction matrices. It further computes a \emph{Gamma value} for each (\eqn{P,Q}) pair, which quantifies the overall interaction strength
using row and column cluster cardinalities and the squared interaction parameters within each bicluster. 
}
\value{
A list of class \code{"MaxInt_data_analysis"} with the following components:

  \item{inference_results}{A data frame containing test statistics, permutation-based p-values, and critical values for REMAXINT and EReMI.}
  \item{Gamma_REMAXINT}{A list of interaction matrices (Gamma) obtained under REMAXINT for each \code{(P, Q)} pair.}
  \item{Z_REMAXINT}{A list of binary row-cluster assignment matrices for REMAXINT.}
  \item{K_REMAXINT}{A list of binary column-cluster assignment matrices for REMAXINT.}
  \item{Gamma_EReMI}{A list of interaction matrices (Gamma) obtained under EReMI for each \code{(P, Q)} pair.}
  \item{Z_EReMI}{A list of binary row-cluster assignment matrices for EReMI.}
  \item{K_EReMI}{A list of binary column-cluster assignment matrices for EReMI.}
  \item{Gamma_results}{A data frame with computed interaction Explained Sum of Squares (iESS) for each cluster configuration.}
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
This function serves as a wrapper for repeated calls to \code{Permutation_Function} to facilitate data analysis for various (\eqn{P,Q}) combinations.
This function is computationally intensive and may take time depending on the number of cluster configurations, permutations, and runs specified. 
Use parallel computing where possible to speed up execution.
}
\seealso{
\code{\link{Permutation_Function}}, \code{\link{screeplot.MaxInt_data_analysis}}, \code{\link{MaxInteraction.plot}}
}
\examples{
set.seed(123)
Data <- matrix(rnorm(60), nrow = 10, ncol = 6)
Clus <- matrix(c(2,2, 2,3, 3,2), ncol = 2, byrow = TRUE)

# Run with default verbose output
result <- MaxInt_data_analysis(Data, Clus, Nruns = 5, permutations = 10, 
					alpha_level = 0.05, verbose = FALSE)
result
}
\keyword{biclustering}
\keyword{Maximal interaction}
\keyword{Permutation based inference}
\keyword{REMAXINT and E-ReMI}
