% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdcont.R
\name{mdcont}
\alias{mdcont}
\title{Linear and Nonlinear Dose-Response Meta-Regression for Continuous Outcomes}
\usage{
mdcont(
  measure = c("MD", "SMD"),
  mean.e,
  sd.e,
  n.e,
  mean.c,
  sd.c,
  n.c,
  dose,
  data,
  linear = TRUE,
  nonlinear = TRUE,
  x_axis = "Dose",
  y_axis = "Measured Effect",
  knots = c(0.1, 0.5, 0.9)
)
}
\arguments{
\item{measure}{Character string specifying the effect size measure.
Options are \code{"MD"} for mean difference or \code{"SMD"} for standardized
mean difference.}

\item{mean.e}{Numeric vector of means in the experimental group.}

\item{sd.e}{Numeric vector of standard deviations in the experimental group.}

\item{n.e}{Numeric vector of sample sizes in the experimental group.}

\item{mean.c}{Numeric vector of means in the control group.}

\item{sd.c}{Numeric vector of standard deviations in the control group.}

\item{n.c}{Numeric vector of sample sizes in the control group.}

\item{dose}{Numeric vector of dose levels corresponding to each study.}

\item{data}{A data frame containing the meta-analysis data.}

\item{linear}{Logical; if \code{TRUE}, a linear dose-response model is fitted.}

\item{nonlinear}{Logical; if \code{TRUE}, a nonlinear dose-response model using
restricted cubic splines is fitted.}

\item{x_axis}{Character string specifying the x-axis label for plots.}

\item{y_axis}{Character string specifying the y-axis label for plots.}

\item{knots}{Numeric vector of quantiles used to place knots for the nonlinear
restricted cubic spline model.}
}
\value{
An S3 object of class `dose`, which is a list containing:
\item{linear_model}{The fitted linear dose-response meta-regression model.}
\item{linear_plot}{A plot of the linear dose-response relationship.}
\item{nonlinear_model}{The fitted nonlinear dose-response meta-regression model.}
\item{nonlinear_plot}{A plot of the nonlinear dose-response relationship.}
}
\description{
Performs linear and/or nonlinear dose-response meta-regression for continuous
outcomes using study-level summary data. The function supports mean difference
(`MD`) and standardized mean difference (`SMD`) effect measures and fits models
across different dose levels using meta-regression techniques.
}
\details{
The function first computes effect sizes and their variances from continuous
outcome data. It then fits a linear dose-response meta-regression model and/or
a nonlinear model using restricted cubic splines, depending on user selection.
Corresponding dose-response plots are generated for visualization.
}
\examples{
# Create a small example dataset
study_data <- data.frame(
  mean.e = c(5.2, 6.1, 7.0, 6.5),
  sd.e   = c(1.1, 1.3, 1.2, 1.0),
  n.e    = c(40, 35, 50, 45),
  mean.c = c(4.8, 5.5, 6.2, 5.9),
  sd.c   = c(1.0, 1.2, 1.1, 1.1),
  n.c    = c(38, 33, 48, 42),
  dose   = c(10, 20, 30, 40)
)

# Fit a dose-response meta-regression model
res <- mdcont(
  measure = "MD",
  mean.e  = mean.e,
  sd.e    = sd.e,
  n.e     = n.e,
  mean.c  = mean.c,
  sd.c    = sd.c,
  n.c     = n.c,
  dose    = dose,
  data    = study_data,
  linear  = TRUE,
  nonlinear = TRUE
)

# Print results
print(res)

# Access components
# res$linear_model
# res$nonlinear_model

}
\seealso{
\code{\link{mdbin}} for dose-response meta-regression with binary outcomes.
}
\author{
Ahmed Abdelmageed \email{ahmedelsaeedmassad@gmail.com}
}
