% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-PCA.R
\name{PCcontrib}
\alias{PCcontrib}
\alias{PCcontrib.PCA}
\title{Shape variation along PC axes}
\usage{
PCcontrib(PCA, ...)

\method{PCcontrib}{PCA}(PCA, nax, sd.r = c(-2, -1, -0.5, 0, 0.5, 1, 2), gap = 1, ...)
}
\arguments{
\item{PCA}{a \code{PCA} object}

\item{...}{additional parameter to pass to \code{\link{coo_draw}}}

\item{nax}{the range of PCs to plot (1 to 99pc total variance by default)}

\item{sd.r}{a single or a range of mean +/- sd values (eg: c(-1, 0, 1))}

\item{gap}{for combined-Coe, an adjustment variable for gap between shapes. (bug)Default
to 1 (whish should never superimpose shapes), reduce it to get a more compact plot.}
}
\value{
(invisibly) a list with \code{gg} the ggplot object and \code{shp} the list of shapes.
}
\description{
Calculates and plots shape variation along Principal Component axes.
}
\examples{
bot.p <- PCA(efourier(bot, 12))
PCcontrib(bot.p, nax=1:3)
\donttest{
library(ggplot2)
gg <- PCcontrib(bot.p, nax=1:8, sd.r=c(-5, -3, -2, -1, -0.5, 0, 0.5, 1, 2, 3, 5))
gg$gg + geom_polygon(fill="slategrey", col="black") + ggtitle("A nice title")
}
}
