% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicalOutputs.R
\name{FEVDandGFEVDgraphs}
\alias{FEVDandGFEVDgraphs}
\title{FEVD and GFEVD graphs for all models}
\usage{
FEVDandGFEVDgraphs(
  ModelType,
  NumOut,
  WishPdynamicsgraphs,
  WishYieldsgraphs,
  FEVDhoriz,
  PathsGraphs,
  OutputType,
  Economies,
  Folder2save,
  verbose
)
}
\arguments{
\item{ModelType}{character. Estimated model type. Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{NumOut}{list. Computed outputs containing model fit, IRFs, FEVDs, GIRFs, GFEVDs and Term premia.}

\item{WishPdynamicsgraphs}{logical. Set TRUE to generate risk factor graphs, FALSE otherwise.}

\item{WishYieldsgraphs}{logical. Set TRUE to generate bond yield graphs, FALSE otherwise.}

\item{FEVDhoriz}{integer. Desired horizon of analysis for the FEVDs.}

\item{PathsGraphs}{character. Path of the folder in which the graphs will be saved.}

\item{OutputType}{character. Available options: "FEVD", "GFEVD", "FEVD Ortho", "GFEVD Ortho".}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{Folder2save}{character. Folder path where the outputs will be stored.}

\item{verbose}{logical. Flag controlling function messaging.}
}
\description{
FEVD and GFEVD graphs for all models
}
\section{Available Methods}{

- `autoplot(object, type = "FEVD_Factor")`, `autoplot(object, type = "FEVD_Yields")`,
  `autoplot(object, type = "GFEVD_Yields")`, `autoplot(object, type = "GFEVD_Yields")`.
  For JLL-based models: `autoplot(object, type = "FEVD_Factor-_Ortho")`, \cr
  `autoplot(object, type = "FEVD_Yields_Ortho")`, `autoplot(object, type = "GFEVD_Yields_Ortho")`,
  `autoplot(object, type = "GFEVD_Yields_Ortho")`.
}

\examples{
data("NumOutEx")
ModelType <- "JPS original"
Economy <- "Brazil"
FEVDhoriz <- 20
FEVDandGFEVDgraphs(ModelType, NumOutEx,
  WishPdynamicsgraphs = FALSE, WishYieldsgraphs = TRUE, FEVDhoriz,
  PathsGraphs = NULL, OutputType = "FEVD", Economy,
  Folder2save = NULL, verbose = FALSE
)

}
