% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantileGpois.R
\name{QuantileGpois}
\alias{QuantileGpois}
\title{Compute the quantile function of the generalized Poisson distribution}
\usage{
QuantileGpois(p, theta, lambda, details = FALSE)
}
\arguments{
\item{p}{vector of probabilities}

\item{theta}{vector of theta}

\item{lambda}{vector of lambda}

\item{details}{A logical flag to return the computational details}
}
\value{
An integer vector of generalized Poisson quantiles corresponding to \code{p}.
}
\description{
This function evaluates the generalized Poisson quantile \eqn{Q(p)} by
incrementally constructing the PMF and CDF from \eqn{x=0} upward until the
CDF exceeds the largest requested probability in \code{p}. The returned
quantile(s) are the smallest integer \eqn{x} such that \eqn{P(X \le x) \ge p}.
}
\examples{
QuantileGpois(p = 0.95, theta = 2, lambda = 0.1)

}
