% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecursionF.r
\name{IntHermiteN}
\alias{IntHermiteN}
\title{IntHermiteN}
\usage{
IntHermiteN(x, K, type = c("lower", "upper"))
}
\arguments{
\item{x}{Numeric vector of lenght \eqn{d}}

\item{K}{Integer. The order of the Hermite polynomial + 1.}

\item{type}{Character string specifying the integration range.
Must be one of:
\itemize{
  \item \code{"lower"}: integrate from \eqn{-\infty} to \eqn{x}
  \item \code{"upper"}: integrate from \eqn{x} to \eqn{+\infty}
}}
}
\value{
A list of integrated Hermite polynomials up to order K-1.
}
\description{
Computes the integrals of d-Hermite polynomial with respect to the normal density
\deqn{\int_{-\infty }^{\mathbf{y}}\mathbf{H}_{k-1}\left( \mathbf{s}\right) \varphi
\left( \mathbf{s}\right) d \,\mathbf{s}}
either from \eqn{-\infty} to \eqn{\mathbf{y}} (type = "lower")
or from \eqn{\mathbf{y}} to \eqn{+\infty} ( type = "upper").
}
\examples{
x <- c(1,2)
IntHermiteN(x, K = 3,type = "lower")

}
