% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionQueries.R
\name{getPredictionTopPredictors}
\alias{getPredictionTopPredictors}
\title{Extract the top N predictors per model}
\usage{
getPredictionTopPredictors(
  connectionHandler,
  schema,
  plpTablePrefix = "plp_",
  cgTablePrefix = "cg_",
  targetIds = NULL,
  outcomeIds = NULL,
  numberPredictors = 100
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{plpTablePrefix}{The prefix used for the patient level prediction results tables}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}

\item{outcomeIds}{A vector of integers corresponding to the outcome cohort IDs}

\item{numberPredictors}{the number of predictors per model to return}
}
\value{
Returns a data.frame with the columns: 
\itemize{
 \item{databaseName the name of the database the model was developed on}
 \item{tarStartDay the time-at-risk start day}
 \item{tarStartAnchor whether the time-at-risk start is relative to cohort start or end}
 \item{tarEndDay the time-at-risk end day}
 \item{tarEndAnchor whether the time-at-risk end is relative to cohort start or end}
 \item{performanceId a unique identifier for the performance}
 \item{covariateId the FeatureExtraction covariate identifier}
 \item{covariateName the name of the covariate}
 \item{conceptId the covariates corresponding concept or 0}
 \item{covariateValue the feature importance or coefficient value}
 \item{covariateCount how many people had the covariate}
 \item{covariateMean the fraction of the target population with the covariate}
 \item{covariateStDev the standard deviation}
 \item{withNoOutcomeCovariateCount the number of the target population without the outcome with the covariate}
 \item{withNoOutcomeCovariateMean the fraction of the target population without the outcome with the covariate}
 \item{withNoOutcomeCovariateStDev the covariate standard deviation of the target population without the outcome}
 \item{withOutcomeCovariateCount the number of the target population with the outcome with the covariate}
 \item{withOutcomeCovariateMean the fraction of the target population with the outcome with the covariate}
 \item{withOutcomeCovariateStDev the covariate standard deviation of the target population with the outcome}
 \item{standardizedMeanDiff the standardized mean difference comparing the target population with outcome and without the outcome}
 \item{rn the row number showing the covariate rank}
}
}
\description{
This function extracts the top N predictors per model from the prediction results tables
}
\details{
Specify the connectionHandler, the resultDatabaseSettings and (optionally) any targetIds or outcomeIds to restrict models to
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

topPreds <- getPredictionTopPredictors(
  connectionHandler = connectionHandler, 
  schema = 'main',
  targetIds = 1,
  outcomeIds = 3
)

}
\seealso{
Other Prediction: 
\code{\link{getPredictionCohorts}()},
\code{\link{getPredictionDiagnosticTable}()},
\code{\link{getPredictionDiagnostics}()},
\code{\link{getPredictionHyperParamSearch}()},
\code{\link{getPredictionIntercept}()},
\code{\link{getPredictionModelDesigns}()},
\code{\link{getPredictionPerformanceTable}()},
\code{\link{getPredictionPerformances}()}
}
\concept{Prediction}
