% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/databaseCharacteristics.R
\name{databaseCharacteristics}
\alias{databaseCharacteristics}
\title{Summarise Database Characteristics for OMOP CDM}
\usage{
databaseCharacteristics(
  cdm,
  omopTableName = c("visit_occurrence", "visit_detail", "condition_occurrence",
    "drug_exposure", "procedure_occurrence", "device_exposure", "measurement",
    "observation", "death"),
  sample = NULL,
  sex = FALSE,
  ageGroup = NULL,
  dateRange = NULL,
  interval = "overall",
  conceptIdCounts = FALSE,
  ...
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object. Use \emph{CDMConnector} to create a reference
to a database or \emph{omock} to create a reference to synthetic data.}

\item{omopTableName}{A character vector of the names of the tables to
summarise in the cdm object. Run \code{clinicalTables()} to check the
available options.}

\item{sample}{Either an integer or a character string.
\itemize{
\item If an integer (n > 0), the function will first sample \code{n} distinct
\code{person_id}s from the \code{person} table and then subset the input tables to
those subjects.
\item If a character string, it must be the name of a cohort in the \code{cdm}; in
this case, the input tables are subset to subjects (\code{subject_id}) belonging
to that cohort.
\item Use \code{NULL} to disable subsetting (default value).
}}

\item{sex}{Logical; whether to stratify results by sex (\code{TRUE}) or not
(\code{FALSE}).}

\item{ageGroup}{A list of age groups to stratify the results by. Each element
represents a specific age range. You can give them specific names, e.g.
\code{ageGroup = list(children = c(0, 17), adult = c(18, Inf))}.}

\item{dateRange}{A vector of two dates defining the desired study period.
Only the \code{start_date} column of the OMOP table is checked to ensure it falls within this range.
If \code{dateRange} is \code{NULL}, no restriction is applied.}

\item{interval}{Time interval to stratify by. It can either be "years",
"quarters", "months" or "overall".}

\item{conceptIdCounts}{Logical; whether to summarise concept ID counts
(\code{TRUE}) or not (\code{FALSE}).}

\item{...}{additional arguments passed to the OmopSketch functions that are
used internally.}
}
\value{
A \code{summarised_result} object with the results.
}
\description{
Summarise Database Characteristics for OMOP CDM
}
\examples{
\dontrun{
library(OmopSketch)
library(omock)
library(dplyr)
library(here)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

result <- databaseCharacteristics(
  cdm = cdm,
  sample = 100,
  omopTableName = c("drug_exposure", "condition_occurrence"),
  sex = TRUE,
  ageGroup = list(c(0, 50), c(51, 100)),
  interval = "years",
  conceptIdCounts = FALSE
)

result |>
  glimpse()

shinyCharacteristics(result = result, directory = here())

cdmDisconnect(cdm = cdm)
}

}
