% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OralOpioids.R
\name{load_Opioid_Table}
\alias{load_Opioid_Table}
\title{Obtain the latest Opioid data}
\usage{
load_Opioid_Table(
  filelocation = "",
  no_download = FALSE,
  verbose = TRUE,
  country = "ca"
)
}
\arguments{
\item{filelocation}{String. The directory on your system where you want the dataset to be downloaded.
If "", filelocation will be set to the download path within the OralOpioids
package installation directory.}

\item{no_download}{Logical. If set to TRUE, no downloads will be executed and no user input is required. Default: \code{FALSE}.}

\item{verbose}{Logical. Indicates whether messages will be printed in the console. Default: \code{TRUE}.}

\item{country}{String. Either "ca" (Canada), or "usa" (USA). Default: \code{"ca"}.}
}
\value{
The function returns the Opioid_Table as a data.frame. Comments on the data.frame
include a status message (msg), the Opioid_Table save path (path),
a disclaimer, and the source for the retrieved data (source_url_data and source_url_dosing).
}
\description{
\code{load_Opioid_Table} compares the date of the local Opioid_Table and compares
it with the latest date of data. In case the local file is outdated,
an updated file will be generated.
}
\examples{
  FDA_Opioid_Table <- load_Opioid_Table(no_download = TRUE, country = "usa")
  head(FDA_Opioid_Table)

}
