% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRecordings.R
\name{addRecordings}
\alias{addRecordings}
\alias{mapWavFolder}
\title{Add Recordings to an AcousticStudy Object}
\usage{
addRecordings(
  x,
  folder = NULL,
  log = FALSE,
  fileFormat = NULL,
  dateFormat = NULL,
  progress = TRUE
)

mapWavFolder(
  folder = NULL,
  log = NULL,
  progress = TRUE,
  fileFormat = NULL,
  dateFormat = NULL
)
}
\arguments{
\item{x}{a \linkS4class{AcousticStudy} object to add recordings to}

\item{folder}{a folder of recordings to add. If \code{NULL}, user will be
prompted to select a folder of recordings for each database present in
\code{x}. If a single folder, this will be applied to all databases. If
multiple folders, length must be equal to the number of databases and they
will be applied to each database in the provided order.}

\item{log}{(optional) log files for SoundTrap recordings. These are used to
adjust apparent lengths of recordings for missing data. If \code{NULL}, user
will be prompted to provide a folder (selecting no folder is a valid option here).
If \code{FALSE} this step will be skipped. If a single folder or multiple folders
will be applied similar to \code{folder}}

\item{fileFormat}{optional file date format regex to extract date from file names
See Details for more information.}

\item{dateFormat}{matching date format for \code{fileFormat} in \link{strptime}
format. See Details for more information.}

\item{progress}{logical flag to show progress bars}
}
\value{
the same object as \code{x} with recording information added
  to the \code{files} slots. The information added is a dataframe containing
  the start and end times of recording
}
\description{
Adds recording files to an AcousticStudy object, runs
  interactively to allow users to select files if they are not
  provided. No actual
  recordings are stored, a dataframe containing information on the
  start and end times of the recording files is added to the object.
}
\details{
\strong{Custom Date Format} using \code{fileFormat} and \code{dateFormat}.
  This is optional, and only required if the built in options do not work
  and you get the warning message "Could not convert wav names to time properly
  for files..."
   
  \code{fileFormat} must be a regular expression designed to extract the
  numbers that represent the datetime from the recording file, and only
  these numbers. This portion of the regex must be wrapped in parentheses.
  
  \code{dateFormat} must be a strptime style date format that matches the
  datetime text extracted by \code{fileFormat}. 
  
  Examples: a wav file named "Recording_20101201-230112.wav" (where the
  numbers are in yyyymmdd-hhmmss) would have 
  \code{fileFormat=".*_([0-9]{8}\\\\-[0-9]{6})\\\\.wav$"} and
  \code{dateFormat="\%Y\%m\%d-\%H\%M\%S"}.
  
  A wav file named "01122010230112_CH2.wav" (where the numbers are in
  ddmmyyyyhhmmss) would have 
  \code{fileFormat="([0-9]{14})_CH[0-9]{1}\\\\.wav$"} and
  \code{dateFormat="\%d\%m\%Y\%H\%M\%S"}. Both examples are for a file datetime
  of "2010-12-01 23:01:12".

  \code{mapWavFolder} returns a dataframe of start and end times
}
\examples{

data(exStudy)
recs <- system.file('extdata', 'Recordings', package='PAMpal')
exStudy <- addRecordings(exStudy, folder=recs, log=FALSE, progress=FALSE)
files(exStudy)$recordings

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
