#include <R.h>
#include <Rinternals.h>
#include <R_ext/Rdynload.h>

/* Declarations for .C entry points defined in api.cpp */
void Dantzig_api(int *n, int *d, double *x, double *y, int *max_it,
                 double *lambda_threshold, int *T, double *lambda_list,
                 double *x_list, double *y_list);
void SparseSVM_api(int *n, int *d, double *x, double *y, int *max_it,
                   double *lambda_threshold, int *T, double *lambda_list,
                   double *x_list, double *y_list, double *x0_list);
void QuantileRegression_api(int *n, int *d, double *x, double *y, double *tau,
                            int *max_it, double *lambda_threshold, int *T,
                            double *lambda_list, double *x_list,
                            double *y_list);
void CompressedSensing_api(int *n, int *d, double *x, double *y, int *max_it,
                           double *lambda_threshold, int *T,
                           double *lambda_list, double *x_list,
                           double *y_list);
void ParametricSimplexMethod_api(int *m, int *n, double *a, double *b,
                                 double *b_bar, double *c, double *c_bar,
                                 int *max_it, double *lambda_threshold, int *T,
                                 double *lambda_list, double *x_list,
                                 double *y_list, int *B_init);

static const R_CMethodDef CEntries[] = {
    {"Dantzig_api", (DL_FUNC) &Dantzig_api, 10},
    {"SparseSVM_api", (DL_FUNC) &SparseSVM_api, 11},
    {"QuantileRegression_api", (DL_FUNC) &QuantileRegression_api, 11},
    {"CompressedSensing_api", (DL_FUNC) &CompressedSensing_api, 10},
    {"ParametricSimplexMethod_api", (DL_FUNC) &ParametricSimplexMethod_api, 14},
    {NULL, NULL, 0}
};

void R_init_PRIMAL(DllInfo *dll) {
    R_registerRoutines(dll, CEntries, NULL, NULL, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
