\name{compute_msg}
\alias{compute_msg}
\title{Compute Maximum Stress-adjusted Germination (MSG)}
\description{
Calculates MSG as the maximum cumulative germination fraction across
all observed timepoints.
}
\usage{
compute_msg(germination_counts, total_seeds)
}
\arguments{
  \item{germination_counts}{Integer vector of cumulative germination counts
    at each timepoint.}
  \item{total_seeds}{Integer. Total number of seeds in the replicate.}
}
\value{
Numeric value in \code{[0, 1]} representing the maximum germination
fraction.
}
\examples{
compute_msg(c(5, 15, 20), total_seeds = 25)
compute_msg(c(0, 0, 0), total_seeds = 25)
}
\seealso{\code{\link{compute_psri_sm}}}
