% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{analyze_best_six_symptoms_four_required}
\alias{analyze_best_six_symptoms_four_required}
\title{Find optimal non-hierarchical six-symptom combinations for PTSD diagnosis}
\usage{
analyze_best_six_symptoms_four_required(data, score_by = "false_cases")
}
\arguments{
\item{data}{A dataframe containing exactly 20 columns with PCL-5 item scores
  (output of rename_ptsd_columns). Each symptom should be scored on a 0-4
  scale where:

\itemize{
  \item 0 = Not at all
  \item 1 = A little bit
  \item 2 = Moderately
  \item 3 = Quite a bit
  \item 4 = Extremely
}}

\item{score_by}{Character string specifying optimization criterion:

\itemize{
  \item "false_cases": Minimize total misclassifications
  \item "newly_nondiagnosed": Minimize false negatives only
}}
}
\value{
A list containing:

\itemize{
  \item best_symptoms: List of three vectors, each containing six symptom numbers
    representing the best combinations found
  \item diagnosis_comparison: Dataframe comparing original DSM-5 diagnosis with
    diagnoses based on the three best combinations
  \item summary: Interactive datatable (DT) showing diagnostic accuracy metrics
    for each combination
}
}
\description{
Identifies the three best six-symptom combinations for PTSD diagnosis
where any four symptoms must be present, regardless of their cluster membership.
This function implements a simplified diagnostic approach compared to the full
DSM-5 criteria.
}
\details{
The function:

\enumerate{
 \item Tests all possible combinations of 6 symptoms from the 20 PCL-5 items
 \item Requires 4 symptoms to be present (>=2 on original 0-4 scale) for diagnosis
 \item Identifies the three combinations that best match the original DSM-5 diagnosis
}

Optimization can be based on either:

\itemize{
\item Minimizing false cases (both false positives and false negatives)
\item Minimizing only false negatives (newly non-diagnosed cases)
}

The symptom clusters in PCL-5 are:

\itemize{
\item Items 1-5: Intrusion symptoms (Criterion B)
\item Items 6-7: Avoidance symptoms (Criterion C)
\item Items 8-14: Negative alterations in cognitions and mood (Criterion D)
\item Items 15-20: Alterations in arousal and reactivity (Criterion E)
}
}
\examples{
# Create example data
ptsd_data <- data.frame(matrix(sample(0:4, 200, replace=TRUE), ncol=20))
names(ptsd_data) <- paste0("symptom_", 1:20)

\donttest{
# Find best combinations minimizing false cases
results <- analyze_best_six_symptoms_four_required(ptsd_data, score_by = "false_cases")

# Get symptom numbers
results$best_symptoms

# View raw comparison data
results$diagnosis_comparison

# View summary statistics
results$summary
}

}
