% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{plot_CountData}
\alias{plot_CountData}
\title{Plot Protein groups per Raw file}
\usage{
plot_CountData(data, y_max, thresh_line, title)
}
\arguments{
\item{data}{A data.frame with columns 'fc.raw.file', 'counts', 'category'}

\item{y_max}{Plot limit of y-axis}

\item{thresh_line}{Position of a threshold line, indicating the usual target value}

\item{title}{Main title, and optional subtitle (if vector of length 2 is provided)}
}
\value{
GGplot object
}
\description{
The input is a data.frame with protein/peptide counts, where 'category' designates
the origin of information (genuine ID, transferred ID, or both).
}
\examples{

 data = data.frame(fc.raw.file = rep(c("file A", "file B"), each=3),
                   counts = c(3674, 593, 1120, 2300, 400, 600),
                   category = c("genuine","genuine+transferred","transferred"))
 plot_CountData(data, 6000, 4000, c("EVD: Protein Groups count", "gain: 23\%"))

}
