% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{addConceptName}
\alias{addConceptName}
\title{Add concept name for each concept_id}
\usage{
addConceptName(table, column = NULL, nameStyle = "{column}_name")
}
\arguments{
\item{table}{cdm_table that contains column.}

\item{column}{Column to add the concept names from. If NULL any column that
its name ends with \code{concept_id} will be used.}

\item{nameStyle}{Name of the new column.}
}
\value{
table with an extra column with the concept names.
}
\description{
Add concept name for each concept_id
}
\examples{
\donttest{
library(PatientProfiles)
library(omock)
library(dplyr, warn.conflicts = FALSE)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

cdm$drug_exposure |>
  addConceptName(column = "drug_concept_id", nameStyle = "drug_name") |>
  glimpse()

cdm$drug_exposure |>
  addConceptName() |>
  glimpse()
}

}
